/***************************************************************************
                          csvfile.h  -  description
                             -------------------
    begin                : Mon Mar 28 2005
    copyright            : (C) 2005 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CSVFILE_H
#define CSVFILE_H

#include <qfile.h>
#include <qstringlist.h>
#include <qtextstream.h>

struct labelprinterdata;
class QBuffer;

/** This class makes it very easy to parse a comma separated value file
 */
class CSVFile {
    public:
       CSVFile( const QString & filename );
       CSVFile( QBuffer & buf );
       ~CSVFile();

       /** reads the next line from the CSV file and returns 
	 * the line split into sections. Comments are ignored by this
	 * line. 
	 */
       QStringList readNextLine();

       /** returns true when the CSVFile object is valid.
	*  returns false incase of an error
	*/
       inline bool isValid() const;

       /** returns true when the end of file was reached
	*/
       inline bool isEof() const;

       /** set the encoding to use for the data
        */
       void setEncoding( const QString & enc );

    private:
       /** removes quoting characters as defined in lpdata from the 
	* string @p text
	*/
       QString removeQuote( const QString & text );

    private:
       /** the filehandle which is used to access the file
	*/
       QFile       m_file;
       QTextStream m_stream;

       labelprinterdata* m_lpdata;

       bool m_eof;
};

bool CSVFile::isValid() const
{
    if( !m_stream.device() )
	return false;

    return m_stream.device()->isOpen();
}

bool CSVFile::isEof() const
{
    return m_eof;
}

#endif // CSVFILE_H
