/***************************************************************************
                          sitemanagerdb.cpp  -  description
                             -------------------
    begin                : tis mar 12 2002
    copyright            : (C) 2002 by Bjrn Sahlstrm
    email                : kbjorn@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

//////////////////////////////////////////////////////////////////////
// Qt specific include files
#include <qfile.h>
#include <qxml.h>
//////////////////////////////////////////////////////////////////////
// KDE specific include files
#include <kstandarddirs.h>
#include <kiconloader.h>
#include <kconfig.h>
#include <kio/job.h>
#include <kio/jobclasses.h>
#include <kglobal.h>
#include <klocale.h>
#include <kdebug.h>
//////////////////////////////////////////////////////////////////////
// Application specific include files
#include "sitemanagerdb.h"

//-----------------------------------------------
SiteManagerDB::SiteManagerDB()
	:	DCOPObject("SiteManagerDBInterface"),
		m_oldSiteManagerFile( QString::null ),
		m_encoding( KGlobal::locale()->encoding() ),
		m_private( new SiteManagerDBSignaler(this) ),
		m_dockWindow( 0L )
		
 {
	kapp->dcopClient()->setDefaultObject( objId() );
	// create the system tray icon
	m_dockWindow = new KSystemTray( kapp->mainWidget(), "SiteManagerDockWindow" );		
	m_dockWindow->setPixmap( KGlobal::iconLoader()->loadIcon("kbearsitemanager", KIcon::Small ) );

	/*
	First we do a little check so sitemanager.xml been installed properly
	If the installation failed somehow it's probably by wrong environment variables.
	In that case we warn the user.
	*/		
	m_siteManagerFile = locateLocal( "data", "kbear/sitemanager.xml" );
	bool found = false;
	if( ! QFile::exists( m_siteManagerFile ) ) {
		m_oldSiteManagerFile = locateLocal( "data", "kbear/sitemanager" );
		if( ! QFile::exists( m_oldSiteManagerFile ) ) {
			m_oldSiteManagerFile = locateLocal( "data", "kbear/sitemanager_1_3" );
			if( ! QFile::exists( m_oldSiteManagerFile ) )
				m_oldSiteManagerFile = QString::null;				
		}
		m_siteManagerFile = locate( "data", "kbear/sitemanager.xml" );
		if( ! QFile::exists( m_siteManagerFile ) )
			kdError()<<"File open error ! File: sitemanager.xml doesn't exist!"<<endl;
		else {
			found = true;
		}
	}
	else
		found = true;
	if( found ) {
		QFile file( m_siteManagerFile );
		file.open(IO_ReadOnly);
		if( ! m_siteDataBase.setContent( &file ) )
			kdError()<<QString("Parse Error: Parsing error for file %1" ).arg( m_siteManagerFile )<<endl;
		else
			m_encoding = encoding();
	}

	makeValidDomTree();  // we have to make sure that we have a valid dom document

	// Even if errors we ignore it an continue with an empty file
	m_siteManagerFile = locateLocal( "data", "kbear/sitemanager.xml" );
	save(); // save it in $HOME/$KDEDIR/share/apps/kbear
	QByteArray data;
	emitDCOPSignal("initialize()",data);

	if( ! m_oldSiteManagerFile.isNull() ) {
		QDataStream arg( data, IO_WriteOnly );
		arg << m_oldSiteManagerFile;
		emitDCOPSignal("importOldSitemanager(QString)",data);
	}

	QObject::connect( m_private->timer(), SIGNAL( timeout() ), m_private, SLOT( slotTimeout() ) );
	m_private->m_timer.start( 30000 );
//	if( kapp->isRestored() ) {
	KConfig c( "kbearsitemanagerrc" );
	showSystemTrayIcon( c.readBoolEntry( "ShowSysemTrayIcon", true ) );
	setPlugInKonq( c.readBoolEntry( "PlugInKonq", false ) );
//	}
}
//-----------------------------------------------
SiteManagerDB::~SiteManagerDB(){
	delete m_private;
	if( m_dockWindow )
		delete m_dockWindow;
}
//-----------------------------------------------
bool SiteManagerDB::ping() {
	m_private->m_gotPing = true;
	return true;
}
//-----------------------------------------------
void SiteManagerDB::regReferer() {
/* We don't use this for now
		m_referers.push_back( kapp->dcopClient()->senderId() );
*/
}
//-----------------------------------------------
void SiteManagerDB::unregReferer( const QCString& /*referer*/ ) {
/* We don't use this for now
	QValueList<QCString>::Iterator it = m_referers.find( referer );
	if( it == m_referers.end() ) {
		kdWarning()<<referer<<" not registered count="<<m_referers.count()<<endl;
	}
	else
		m_referers.remove( it );
	if( m_referers.isEmpty() ) {
		kapp->quit();
	}
*/
}
//-----------------------------------------------
void SiteManagerDB::unregReferer() {
/* We don't use this for now
	unregReferer( kapp->dcopClient()->senderId() );
*/
}
//-----------------------------------------------
QDomNode SiteManagerDB::findSite( const Site& site ) {
	QDomElement parent = findParent( site.parent() );	
	return findNodeByAttribute( parent, "site", "label", site.label() );
}
//-----------------------------------------------
QDomNode SiteManagerDB::findGroup( const Group& group ) {
	QDomElement parent = findParent( group.parent() );	
	return findNodeByAttribute( parent, "group", "label", group.label() );
}
//-----------------------------------------------
QDomElement SiteManagerDB::findParent( const QString& parentStr ) {
	QDomElement parent = m_siteDataBase.documentElement();
	QDomNodeList list = m_siteDataBase.documentElement().childNodes();
	QStringList parentStrList = QStringList::split( "/", parentStr );
	for( QStringList::Iterator it = parentStrList.begin(); it != parentStrList.end(); ++it ) {
		for( unsigned int j = 0; j < list.length(); j++ ) {
			if( list.item( j ).toElement().tagName() == "group" && list.item( j ).toElement().attribute("label") == (*it) ) {
				parent = list.item( j ).toElement();
				list = list.item( j ).childNodes();
				j = list.length();
			}
		}
	}
	return parent;
}
//-----------------------------------------------
QDomNode SiteManagerDB::findNodeByAttribute( QDomElement parent, const QString& tagName,
										const QString& attribute, const QString& label ) {
	QDomNodeList siteList = parent.childNodes();
	for( unsigned int i = 0; i < siteList.count(); i++ ) {
		if( siteList.item( i ).toElement().tagName() == tagName && label == siteList.item( i ).toElement().attribute( attribute ) ) {
			return siteList.item( i );
		}
	}
	return QDomNode();
}
//-----------------------------------------------
void SiteManagerDB::saveSite( Site site ) {
	if( site.label().isEmpty() || site.label().isNull() )  // we don't want an empty label
		site.setLabel( i18n( "No Name" ) );

	if( ! addSite( site ) )
			return;

	save();

	QByteArray data;
	QDataStream arg( data, IO_WriteOnly );
	arg << site;
	emitDCOPSignal( "newSite(Site)", data );
}
//-----------------------------------------------
bool SiteManagerDB::addSite( Site& site ) {
	QDomElement parent;
	if( site.parent() == QString::null )
		parent = m_siteDataBase.documentElement();
	else
		parent = findParent( site.parent() );
	if( parent.isNull() ) // wasn't able to set parent node
		return false;
	addSite( parent, site );
	return true;
}
//-----------------------------------------------
void SiteManagerDB::addSite( QDomElement parentNode, Site& site ) {
	QString result;
	int num = 1;
	QString addStr = QString::null;
	bool exist;
	QDomNodeList list = parentNode.childNodes();
	do {
		exist = false;
		addStr = ( ( num>1 ) ? (" ("+QString::number(num)+")" ): QString::null ) ;	
		result = site.label() + addStr;	
		++num;
		for( unsigned int i = 0; i < list.count(); i++ ) {
			if( ! findNodeByAttribute( parentNode, "site", "label", result ).isNull() )
				exist = true;
		}

	}while( exist );	

	site.setLabel( result );
	QDomElement element = addEmptyElement( parentNode, "site" );
	element.setAttribute( "label", site.label() );
	addTextNode( element, "protocol", site.protocol() );
	addTextNode( element, "host", site.host() );
	addTextNode( element, "port", QString::number( site.port() ) );
	if( site.user() != QString::null )
		addTextNode( element, "user", site.user() );
	if( site.pass() != QString::null )
		addTextNode( element, "pass", site.pass() );
	if( site.remotePath() != QString::null )
		addTextNode( element, "remote_path", site.remotePath() );
	if( site.localPath() != QString::null )
		addTextNode( element, "local_path", site.localPath() );
	if( site.description() != QString::null )
		addTextNode( element, "description", site.description() );
	if( site.anonym() )
		addEmptyElement( element, "anonymous" );
	if( ! site.passiveMode() )
		addEmptyElement( element, "disable_pasv" );
	if( ! site.extendedPassiveMode() )
		addEmptyElement( element, "disable_epsv" );
	if( ! site.listA() )
		addEmptyElement( element, "disable_list_a" );
	if( ! site.binaryMode() )
		addEmptyElement( element, "ascii" );
	if( ! site.enableLog() )
		addEmptyElement( element, "disable_log" );
	if( site.markPartial() )
		addEmptyElement( element, "mark_partial" );
	if( site.queue() )
		addEmptyElement( element, "queue" );
	if( site.singleConnection() )
		addEmptyElement( element, "single_connection" );
	if( site.autoReconnect() ) {
		QDomElement tmpElement = addEmptyElement( element, "auto_reconnect" );
		tmpElement.setAttribute("sleep", QString::number( site.reconnectTime() ) );
		tmpElement.setAttribute("count", QString::number( site.numOfRetries() ) );
	}
	QDomElement tmpElement = addEmptyElement( element, "filesys_encoding" );
	tmpElement.setAttribute("encoding", site.fileSysEncoding() );
}
//-----------------------------------------------
void SiteManagerDB::removeSite( Site site ) {
	QDomNode siteNode = findSite( site );
	if( siteNode.isNull() )
		return;

	QDomNode parent = siteNode.parentNode();
	parent.removeChild( siteNode );
	
	save();

	QByteArray data;
	QDataStream arg( data, IO_WriteOnly );;
	arg << site;
	emitDCOPSignal( "siteRemoved(Site)", data );
}
//-----------------------------------------------
void SiteManagerDB::moveSite( Site site, QString newParent ) {
	QDomNode siteNode = findSite( site );
	if( siteNode.isNull() )
		return;

	// we need to save original name
	QString oldName = site.label();

	QDomNode oldParentNode = siteNode.parentNode();
	QDomNode newParentNode = findParent( newParent );
	if( oldParentNode == newParentNode )
		return;
	QString oldParent = getFullPath ( oldParentNode.toElement() );
	QDomNode clonedNode = siteNode.cloneNode( true );
	oldParentNode.removeChild( siteNode );

	// we have to check if the name exist, if so rename
	QDomNodeList list = newParentNode.childNodes();
	QString result;
	int num = 1;
	QString addStr = QString::null;
	bool exist;
	do {
		exist = false;
		addStr = ( ( num>1 ) ? (" ("+QString::number(num)+")" ): QString::null ) ;	
		result = site.label() + addStr;	
		++num;
		for( unsigned int i = 0; i < list.count(); i++ ) {
			if( list.item( i ).toElement().attribute("label") == result )
				exist = true;
		}

	}while( exist );	

	clonedNode.toElement().setAttribute( "label", result );
	newParentNode.appendChild( clonedNode );
	
	save();
	
	site.setLabel( result );
	site.setParent( newParent );
	QByteArray data;
	QDataStream arg( data, IO_WriteOnly );
	arg << site << oldParent << oldName;
	emitDCOPSignal( "siteMoved(Site,QString,QString)", data );
}
//-----------------------------------------------
void SiteManagerDB::changeSite( Site site, QString oldLabel ) {
	QDomElement parent = findParent( site.parent() );
	QDomNode node =  findNodeByAttribute( parent, "site", "label", oldLabel );	
	if( node.isNull() ) // site doesn't exist
		return;

	parent.removeChild( node );
	addSite( parent, site );
		
	save();

	QByteArray data;
	QDataStream arg( data, IO_WriteOnly );
	arg << site << oldLabel;
	emitDCOPSignal( "siteChanged(Site,QString)", data );
}
//-----------------------------------------------
Site SiteManagerDB::getSite( Site site ) {
	QDomNode siteNode = findSite( site );
	if( siteNode.isNull() ) {// not found
		site.setLabel( QString::null );
		return site;
	}
	
	site.setLabel( siteNode.toElement().attribute( "label" ) );

	bool anonymousLogin = false;
	QDomNodeList childs = siteNode.childNodes();		
	for( unsigned int i = 0; i < childs.count(); i++ ) {
		if( childs.item( i ).toElement().tagName() == "host" ) {
			site.setHost( childs.item( i ).toElement().text() );
		}			
		else if( childs.item( i ).toElement().tagName() == "protocol" ) {
			site.setProtocol( childs.item( i ).toElement().text() );
		}			
		else if( childs.item( i ).toElement().tagName() == "port" ) {
			site.setPort( childs.item( i ).toElement().text().toInt() );
		}			
		else if( childs.item( i ).toElement().tagName() == "user" ) {
			site.setUser( childs.item( i ).toElement().text() );
		}			
		else if( childs.item( i ).toElement().tagName() == "pass" ) {
			site.setPass( childs.item( i ).toElement().text() );
		}			
		else if( childs.item( i ).toElement().tagName() == "remote_path" ) {
			site.setRemotePath( childs.item( i ).toElement().text() );
		}			
		else if( childs.item( i ).toElement().tagName() == "local_path" ) {
			site.setLocalPath( childs.item( i ).toElement().text() );
		}			
		else if( childs.item( i ).toElement().tagName() == "description" ) {
			site.setDescription( childs.item( i ).toElement().text() );
		}			
		else if( childs.item( i ).toElement().tagName() == "anonymous" ) {
			anonymousLogin = true;
		}			
		else if( childs.item( i ).toElement().tagName() == "disable_pasv" ) {
			site.setPassiveMode( false );
		}			
		else if( childs.item( i ).toElement().tagName() == "disable_epsv" ) {
			site.setExtendedPassiveMode( false );
		}			
		else if( childs.item( i ).toElement().tagName() == "disable_list_a" ) {
			site.setListA( false );
		}			
		else if( childs.item( i ).toElement().tagName() == "ascii" ) {
			site.setBinaryMode( false );
		}			
		else if( childs.item( i ).toElement().tagName() == "queue" ) {
			site.setQueue( true );
		}			
		else if( childs.item( i ).toElement().tagName() == "single_connection" ) {
			site.setSingleConnection( true );
		}			
/*
		else if( childs.item( i ).toElement().tagName() == "mdtm" ) {
			site.setBinaryMode( false );
		}			
		else if( childs.item( i ).toElement().tagName() == "unix" ) {
			site.setBinaryMode( false );
		}			
*/
		else if( childs.item( i ).toElement().tagName() == "disable_log" ) {
			site.setEnableLog( false );
		}			
		else if( childs.item( i ).toElement().tagName() == "mark_partial" ) {
			site.setMarkPartial( true );
		}			
		else if( childs.item( i ).toElement().tagName() == "auto_reconnect" ) {
			site.setAutoReconnect( true );
			site.setReconnectTime( childs.item( i ).toElement().attribute("sleep").toInt() );
			site.setNumOfRetries( childs.item( i ).toElement().attribute("count").toInt() );
		}
		else if( childs.item( i ).toElement().tagName() == "filesys_encoding" ) {
			site.setFileSysEncoding( childs.item( i ).toElement().attribute("encoding") );
		}
	}
	site.setAnonym( anonymousLogin );
	return site;
}
//-----------------------------------------------
bool SiteManagerDB::addGroup( Group& group ) {
	QDomElement parent;
	if( group.parent() == QString::null )
		parent = m_siteDataBase.documentElement();
	else
		parent = findParent( group.parent() );
	if( parent.isNull() ) // wasn't able to set parent node
		return false;
	addGroup( parent, group );
	return true;
}
//-----------------------------------------------
void SiteManagerDB::addGroup( QDomElement parentNode, Group& group ) {
	QDomNodeList list = parentNode.childNodes();

	QString result;
	int num = 1;
	QString addStr = QString::null;
	bool exist;
	do {
		exist = false;
		addStr = ( ( num>1 ) ? (" ("+QString::number(num)+")" ): QString::null ) ;	
		result = group.label() + addStr;	
		++num;
		for( unsigned int i = 0; i < list.count(); i++ ) {
			if( list.item( i ).toElement().attribute("label") == result )
				exist = true;
		}

	}while( exist );	

	QDomElement element = addEmptyElement( parentNode, "group" );
	element.setAttribute( "label", result );
}
//-----------------------------------------------
void SiteManagerDB::removeGroup( Group group ) {
	QDomNode groupNode = findGroup( group );
	if( groupNode.isNull() )
		return;

	QDomNode parent = groupNode.parentNode();
	parent.removeChild( groupNode );
	
	save();
	
	QByteArray data;
	QDataStream arg( data, IO_WriteOnly );;
	arg << group;
	emitDCOPSignal( "groupRemoved(Group)", data );
}
//-----------------------------------------------
QString SiteManagerDB::getFullPath( QDomElement e ) {
	QString pathName = "/" + e.attribute( "label" );
	while( e != m_siteDataBase.documentElement() ) {
		pathName = "/" + e.attribute( "label" ) + pathName;
		e = e.parentNode().toElement();
	}
	return pathName;
}
//-----------------------------------------------
void SiteManagerDB::moveGroup( Group group, QString newParent ) {
	QDomNode groupNode = findGroup( group );
	if( groupNode.isNull() )
		return;

	QDomNode oldParentNode = groupNode.parentNode();
	QDomNode newParentNode = findParent( newParent );

	if( oldParentNode == newParentNode ) // the group wasn't actually moved
		return;

	QString oldParent = getFullPath ( oldParentNode.toElement() );
	oldParentNode.removeChild( groupNode );
	QDomNode clonedNode = groupNode.cloneNode( true );
	newParentNode.appendChild( clonedNode );

	save();
	
	group.setParent( newParent );	
	QByteArray data;
	QDataStream arg( data, IO_WriteOnly );
	arg << group << oldParent;
	emitDCOPSignal( "groupMoved(Group,QString)", data );
}
//-----------------------------------------------
void SiteManagerDB::saveGroup( Group group ) {
	QDomNode node;
	if( group.label().isEmpty() || group.label().isNull() )  // we don't want an empty label
		group.setLabel( i18n( "No Name" ) );

	if( ! addGroup( group ) )
		return;

	save();
	
	QByteArray data;
	QDataStream arg( data, IO_WriteOnly );
	arg << group;
	emitDCOPSignal( "newGroup(Group)", data );
}
//-----------------------------------------------
void SiteManagerDB::changeGroup( Group group, QString oldLabel ) {
	QString result;
	int num = 1;
	QString addStr = QString::null;
	bool exist;
	QDomElement parentNode = findParent( group.parent() );
	QDomNodeList list = parentNode.childNodes();
	do {
		exist = false;
		addStr = ( ( num>1 ) ? (" ("+QString::number(num)+")" ): QString::null ) ;	
		result = group.label() + addStr;	
		++num;
		for( unsigned int i = 0; i < list.count(); i++ ) {
			if( list.item( i ).toElement().attribute("label") == result )
				exist = true;
		}

	}while( exist );	

	group.setLabel( oldLabel );
	QDomNode groupNode = findGroup( group );
	groupNode.toElement().setAttribute("label", result );
	group.setLabel( result );
	
	save();

	QByteArray data;
	QDataStream arg( data, IO_WriteOnly );
	arg << group << oldLabel;
	emitDCOPSignal( "groupChanged(Group,QString)", data );
}
//-----------------------------------------------
void SiteManagerDB::save(){
	save( m_siteDataBase, m_siteManagerFile );
}
//-----------------------------------------------
void SiteManagerDB::save( QDomDocument doc, const QString& fileName ){
	QFile file( fileName );
	file.open( IO_WriteOnly );
	QTextStream fileStream( &file );
	doc.save( fileStream, 10 );
	fileStream<<flush;
	file.close();
}
//-----------------------------------------------
void SiteManagerDB::makeValidDomTree(){
	QDomDocument tmpDoc; // We build a new document
	//first we need a <sites/> element as root
	QDomElement root;
	QDomElement newRoot;
	if( m_siteDataBase.documentElement().isNull() ) // no root
		newRoot = tmpDoc.createElement( "sites" );
	else {
		QDomElement root = m_siteDataBase.documentElement();
		if( root.tagName() != "sites" ) { // The root isn't a sites tag, sorry ;)
			QString fName = m_siteManagerFile+".old";
			kdError()<<QString("The file: %1 isn't valid. It vill be saved as %2 and a new empty file will be created.").
									arg( "sitemanager.xml" ).arg( fName )<<endl;
			save( m_siteDataBase, fName );	
			newRoot = tmpDoc.createElement( "sites" );
		}
		else
			newRoot = root.cloneNode( true ).toElement();						
	}
	newRoot.setAttribute( "encoding", m_encoding );	

	tmpDoc.setContent( QString("<?xml version=\"1.0\" encoding=\"%1\"?>").arg(m_encoding) );
	tmpDoc.appendChild( newRoot );
	m_siteDataBase.setContent( tmpDoc.toString() );
	// we localize the Personal entry
	QDomNodeList nodeList = m_siteDataBase.elementsByTagName( "group" );
	for( unsigned int i = 0; i < nodeList.count(); i++ ) {
		QString lbl = nodeList.item( i ).toElement().attribute( "label" );
		if( lbl == "Personal" )
			nodeList.item( i ).toElement().setAttribute( "label", i18n("Personal") );
		if( lbl == "Imported Bookmarks" )
			nodeList.item( i ).toElement().setAttribute( "label", i18n("Imported Bookmarks") );
	}
			
}
//-----------------------------------------------
QString SiteManagerDB::encoding() {
	if(m_siteDataBase.documentElement().isElement() ) {
		m_encoding = m_siteDataBase.documentElement().toElement().attribute("encoding");
	}
	else
		m_encoding = QString::null;

	return m_encoding;
}
//-----------------------------------------------
void SiteManagerDB::setEncoding( QString encoding ){
	m_encoding = encoding;
	makeValidDomTree();
	QByteArray data;
	QDataStream arg( data, IO_WriteOnly );
	arg << encoding;
	emitDCOPSignal( "newEncoding", data );
}
//-----------------------------------------------
void SiteManagerDB::importDomDocument( QString domDocument ) {
	QDomElement importElement;
	QDomDocument tmpDoc;
	tmpDoc.setContent( domDocument );
	QDomElement newElement = tmpDoc.documentElement();
	QDomNodeList nodeList = m_siteDataBase.documentElement().childNodes();
	int nodeCount = 0;
	for( unsigned int i = 0; i < nodeList.count(); i++ ) {
		if( nodeList.item( i ).toElement().attribute("label") == i18n("Imported Bookmarks") ) {
			importElement = nodeList.item( i ).toElement();
			QDomNodeList nodeList2 = importElement.childNodes();
			for( unsigned int j = 0; j < nodeList2.count(); j++ ) {
				QString tmp = newElement.attribute( "label" );
				if( nodeList2.item( j ).toElement().attribute("label").left( tmp.length() ) == tmp ) {
					++nodeCount;					
				}
			}
			if( nodeCount > 0 )
				newElement.setAttribute("label", newElement.attribute( "label" )+ QString("(%1)").arg(nodeCount+1) );
		}
	}	
	if( importElement.isNull() ) {
		importElement = addEmptyElement( m_siteDataBase.documentElement(), "group" );
		importElement.setAttribute( "label", i18n("Imported Bookmarks") );
	}

     QDomElement dbNewElement = addEmptyElement( importElement, newElement.tagName() );
	dbNewElement.setAttribute( "label", newElement.attribute( "label" ) );
	
	parseImportTree( newElement, dbNewElement );
	
	save();
	
	QCString signal( "updateDatabase(QString)" );
	QCString e;
	QDataStream stream(e, IO_WriteOnly );
	stream << m_siteDataBase.toString();
	emitDCOPSignal( signal, e );
}
//-----------------------------------------------
void SiteManagerDB::parseImportTree( QDomElement parentElement, QDomElement dbParentElement ) {
	QDomNode node = parentElement.firstChild();
	while( ! node.isNull() ) {
		QString name;
		if( node.toElement().tagName() == "group" ) {
			name = node.toElement().attribute( "label" );
			QDomElement newElement = addEmptyElement( dbParentElement, "group" );
			newElement.setAttribute( "label", name );
			// recursive build of the tree
			parseImportTree( node.toElement(), newElement );
		}
		else if( node.toElement().tagName()  == "site" ) {
			name = node.toElement().attribute( "label" );
			QDomElement newElement = addEmptyElement( dbParentElement, "site" );
			newElement.setAttribute( "label", name );
			// recursive build of the tree
			parseImportTree( node.toElement(), newElement );
		}
		else if( node.isElement() ) {
			QDomElement newElement = addEmptyElement( dbParentElement, node.toElement().tagName() );
			// recursive build of the tree
			parseImportTree( node.toElement(), newElement );
		}
		else if( node.isText() ) {
			QDomText text = m_siteDataBase.createTextNode( node.toText().data() );
			dbParentElement.appendChild( text );
		}
		node = node.nextSibling();
	}
}
//-----------------------------------------------
void SiteManagerDB::addTextNode( QDomElement parentNode, const QString& type, const QString& value ) {
	QDomElement element = addEmptyElement( parentNode, type );
	QDomText text = m_siteDataBase.createTextNode( value );
	element.appendChild( text );
}
//-----------------------------------------------
QDomElement SiteManagerDB::addEmptyElement( QDomElement parentNode, const QString& type ){
	QDomElement element = m_siteDataBase.createElement( type );
	parentNode.appendChild( element );
	return element;
}
//-----------------------------------------------
void SiteManagerDB::showSystemTrayIcon(bool show) {
	kdDebug()<<"SiteManagerDB::showSystemTrayIcon="<<show<<endl;
	if( show )
		m_dockWindow->show();
	else
		m_dockWindow->hide();
	QCString signal( "showSystemTray(bool)" );
	QByteArray data;
	QDataStream stream( data, IO_WriteOnly );
	stream << show;
	emitDCOPSignal( signal, data );
}
//-----------------------------------------------
void SiteManagerDB::setPlugInKonq(bool plug ) {
	kdDebug()<<"SiteManagerDB::setPlugInKonq="<<plug<<endl;
	QString copyFile = locate( "data", "kbear/kpartplugins/kbearsitemanagerui.rc" );
	QString tmpPath = locateLocal( "data", "konqueror/kpartplugins/kbearsitemanagerui.rc" );
	QString listViewPath = locateLocal( "data", "konqlistview/kpartplugins/kbearsitemanagerui.rc" );
	QString iconViewPath = locateLocal( "data", "konqiconview/kpartplugins/kbearsitemanagerui.rc" );
	// this is temp code
	if( KStandardDirs::exists( tmpPath ) )
		KIO::file_delete( tmpPath );
	// temp code end
	if( plug ) {
		if( ! copyFile.isNull() ) {
			if( ! KStandardDirs::exists( listViewPath ) ) 
				KIO::copy( copyFile, listViewPath, false );
			if( ! KStandardDirs::exists( iconViewPath ) ) 
				KIO::copy( copyFile, iconViewPath, false );
		}
	}
	else {
		if( KStandardDirs::exists( listViewPath ) )
			KIO::file_delete( listViewPath );
		if( KStandardDirs::exists( iconViewPath ) )
			KIO::file_delete( iconViewPath );
	}

	QCString signal( "plugInKonq(bool)" );
	QByteArray data;
	QDataStream stream( data, IO_WriteOnly );
	stream << plug;
	emitDCOPSignal( signal, data );
}
//-----------------------------------------------
