/***************************************************************************
                          kbeartabview.cpp  -  description
                             -------------------
    begin                : sn feb 10 2002
    copyright            : (C) 2002 by Bjrn Sahlstrm
    email                : kbjorn@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

//////////////////////////////////////////////////////
// Qt specific includes
/////////////////////////////////////////////////////
// KDE specific includes
#include <kdebug.h>
//////////////////////////////////////////////////////
// Application specific includes
#include "kbeartabview.h"

//-----------------------------------------------
KBearTabView::KBearTabView(QWidget *parent, const char *name )
	:	KDockTabGroup(parent,name),
		m_shouldBeVisible( true )
{
}
//-----------------------------------------------
KBearTabView::~KBearTabView(){
}
//-----------------------------------------------
void KBearTabView::youShouldBeVisible( bool b ) {
	bool showMe = true;
	m_shouldBeVisible = b;
	if( m_shouldBeVisible ) {
		if( count() <= 0 )
			showMe = false;
	}
	else if( ! m_shouldBeVisible ){	
		showMe = false;
	}
	if( showMe ) {
		show();
		emit imShowing();
	}
	else {
		hide();
		emit imHiding();
	}
}
//-----------------------------------------------
int KBearTabView::findTabByCaption( const QString& n ){
	for( int i = 0; i < count(); i++ ) {
		if( label( i ) == n ) {
			return i;
		}
	}
	return -1;
}
//-----------------------------------------------
void KBearTabView::addPage( const QString& ){
	if( m_shouldBeVisible && isHidden() ) {
		show();
		emit imShowing();
	}
}
//-----------------------------------------------
void KBearTabView::removePage( const QString& name ){
	int p = findTabByCaption( name );
	if( p > -1 ) {
		QWidget* w = page( p );
		QTabWidget::removePage( w );
		delete w;
	}
	if( count() <= 0 ) {
		hide();
		emit imHiding();
	}
}
//-----------------------------------------------
#ifndef NO_INCLUDE_MOCFILES
#include "kbeartabview.moc"
#endif
