/***************************************************************************
                          kbeartreeviewitem.cpp  -  description
                             -------------------
    begin                : tor feb 21 2002
    copyright            : (C) 2002 by Bjrn Sahlstrm
    email                : kbjorn@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

//////////////////////////////////////////////////////////////////////
// Qt specific include files
//////////////////////////////////////////////////////////////////////
// KDE specific include files
#include <kiconloader.h>
#include <kmimetype.h>
//////////////////////////////////////////////////////////////////////
// Application specific include files
#include "kbeartreeviewitem.h"

//-----------------------------------------------
QPixmap* KBearTreeViewItem::m_folderOpen = 0L;
QPixmap* KBearTreeViewItem::m_folderClosed = 0L;
//-----------------------------------------------
KBearTreeViewItem::KBearTreeViewItem( QListView* parent, const QString& text )
	:	QListViewItem(parent,text)
{
	setExpandable( true );
	if( m_folderOpen == 0L )
		m_folderOpen = new QPixmap(KGlobal::iconLoader()->loadIcon("folder_open", KIcon::Small ));
	if( m_folderClosed == 0L )
		m_folderClosed = new QPixmap(KMimeType::mimeType("inode/directory")->pixmap(KIcon::Small) );
}
//-----------------------------------------------
KBearTreeViewItem::KBearTreeViewItem( QListViewItem* parent, const QString& text )
	:	QListViewItem(parent,text)
{
	setExpandable( true );
	if( m_folderOpen == 0L )
		m_folderOpen = new QPixmap(KGlobal::iconLoader()->loadIcon("folder_open", KIcon::Small ));
	if( m_folderClosed == 0L )
		m_folderClosed = new QPixmap(KMimeType::mimeType("inode/directory")->pixmap(KIcon::Small) );
}
//-----------------------------------------------
KBearTreeViewItem::~KBearTreeViewItem(){
}
//-----------------------------------------------
void KBearTreeViewItem::setOpen( bool o ) {
	if ( ! isExpandable() ) {
		return;
	}
	else if( o ) {
		setPixmap( *m_folderOpen );
	}
	else {
		setPixmap( *m_folderClosed );
	}
	QListViewItem::setOpen( o );
}
//-----------------------------------------------
void KBearTreeViewItem::setPixmap( const QPixmap& p ) {
	m_pixmap = p;
	QListViewItem::setPixmap( 0, p );
	setup();
	widthChanged( 0 );
	invalidateHeight();
	repaint();
}
//-----------------------------------------------
