/***************************************************************************
                          firewallsettingswidget.cpp  -  description
                             -------------------
    begin                : ons apr 17 2002
    copyright            : (C) 2002 by Bjrn Sahlstrm
    email                : kbjorn@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

//////////////////////////////////////////////////////
// Qt specific includes
#include <qradiobutton.h>
//////////////////////////////////////////////////////
// KDE specific includes
#include <kconfig.h>
#include <kapplication.h>
#include <klocale.h>
#include <kcombobox.h>
#include <knuminput.h>
#include <klineedit.h>
//////////////////////////////////////////////////////
// Application specific includes
#include "firewallsettingswidget.h"
#include "kbear.h"

//-----------------------------------------------
FirewallSettingsWidget::FirewallSettingsWidget(QWidget *parent, const char *name )
	:	FirewallSettingsBase(parent,name)
{
    m_firewallTypeCombo->setCurrentItem( i18n("No firewall") , true );
    m_firewallTypeCombo->setCurrentItem( "USER user@real.host.name" , true );
    m_firewallTypeCombo->setCurrentItem( "USER fwuser PASS fwpassword USER user@real.host.name" , true );
    m_firewallTypeCombo->setCurrentItem( "SITE real.host.name USER user PASS pass" , true );
    m_firewallTypeCombo->setCurrentItem( "OPEN real.host.name USER user PASS pass" , true );
    m_firewallTypeCombo->setCurrentItem( "USER user@fwuser@real.host.name PASS pass@fwpass" , true );
    m_firewallTypeCombo->setCurrentItem( "USER fwuser@real.host.name PASS fwpass USER user PASS pass" , true );
    m_firewallTypeCombo->setCurrentItem( "USER user@real.host.name fwuser PASS passACCT fwpass" , true );
    m_firewallTypeCombo->setCurrentItem( i18n("Special") , true );

	readSettings();
}
//-----------------------------------------------
FirewallSettingsWidget::~FirewallSettingsWidget(){
}
//-----------------------------------------------
void FirewallSettingsWidget::saveSettings() {
	QString oldGroup = kapp->config()->group();
	kapp->config()->setGroup("Firewall");
	kapp->config()->writeEntry( "Type", m_firewallTypeCombo->currentItem() );
	kapp->config()->writeEntry( "Macro", m_firewallSpecialText->text() );		
	kapp->config()->writeEntry( "Host", m_firewallHostEdit->text() );
	kapp->config()->writeEntry( "Port", m_firewallPortSpinBox->value() );
	kapp->config()->writeEntry( "User", m_firewallUserEdit->text() );
	QString tmp = m_firewallPassEdit->text();
	kapp->config()->writeEntry( "Pass", KBear::encodePassword( tmp ) );
	kapp->config()->writeEntry( "Account", m_firewallAccountEdit->text() );
	kapp->config()->setGroup( oldGroup );
}
//-----------------------------------------------
void FirewallSettingsWidget::readSettings() {
	QString oldGroup = kapp->config()->group();
	kapp->config()->setGroup("Firewall");
	unsigned int type = kapp->config()->readUnsignedNumEntry( "Type", NONE );
	m_firewallTypeCombo->setCurrentItem( type );
	slotFirewallTypeActivated( type );
	m_firewallSpecialText->setText( kapp->config()->readEntry( "Macro", QString::null ) );		
	QString tmp = kapp->config()->readEntry( "Host", QString::null );
	m_firewallHostEdit->setText( tmp );
	int p = kapp->config()->readUnsignedNumEntry( "Port", 21 );
	m_firewallPortSpinBox->setValue( p );
	tmp = kapp->config()->readEntry( "User", QString::null );
	m_firewallUserEdit->setText( tmp );
	tmp = kapp->config()->readEntry( "Pass", QString::null );
	m_firewallPassEdit->setText( KBear::decodePassword( tmp ) );
	tmp = kapp->config()->readEntry( "Account", QString::null );
	m_firewallAccountEdit->setText( tmp );
	kapp->config()->setGroup( oldGroup );
}
//-----------------------------------------------
#ifndef NO_INCLUDE_MOCFILES
#include "firewallsettingswidget.moc"
#endif
