/***************************************************************************
                          kbeardirsize.h  -  description
                             -------------------
    begin                : tis sep 17 2002
    copyright            : (C) 2002 by Bjrn Sahlstrm
    email                : kbjorn@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KBEARDIRSIZE_H
#define KBEARDIRSIZE_H

//////////////////////////////////////////////////////////////////////
// Qt specific include files
//////////////////////////////////////////////////////////////////////
// KDE specific include files
#include <kio/job.h>
#include <kfileitem.h>
//////////////////////////////////////////////////////////////////////
// Application specific include files


/**
  *@author Bjrn Sahlstrm, hacked from KDirSize
  */



/**
 * Computes a directory size (similar to "du", but doesn't give the same results
 * since we simply sum up the dir and file sizes, whereas du speaks disk blocks)
 */
class KBearDirSize : public KIO::Job {
	Q_OBJECT
protected:
	KBearDirSize( unsigned long id, const KURL & directory );
	KBearDirSize( unsigned long id, const KFileItemList & lstItems );
	~KBearDirSize() {}

public:
	/**
	* @return the size we found
	*/
	KIO::filesize_t totalSize() const { return m_totalSize; }
	/**
	* Asynchronous method. Connect to the result signal.
	* This one lists a single directory.
	*/
	static KBearDirSize * dirSizeJob( unsigned long id, const KURL & directory );

	/**
	* Asynchronous method. Connect to the result signal.
	* This one lists the items from @p lstItems.
	* The reason we asks for items instead of just urls, is so that
	* we directly know if the item is a file or a directory,
	* and in case of a file, we already have its size.
	*/
	static KBearDirSize * dirSizeJob( unsigned long id, const KFileItemList & lstItems );

	/**
	* Synchronous method - you get the result as soon as
	* the call returns.
	*/
//	static KIO::filesize_t dirSize( const KURL & directory );
protected:
	/**
	* @internal
	*/
	void setSync() { m_bAsync = false; }

	void startNextJob( const KURL & url );

protected slots:

	virtual void slotResult( KIO::Job *job );
	void slotEntries( KIO::Job * , const KIO::UDSEntryList & );
	void processList();

private:
	bool m_bAsync;
	KIO::filesize_t m_totalSize;
	KFileItemList m_lstItems;
private:
	unsigned long m_ID; 
	class KBearDirSize* d;
};

#endif
