/***************************************************************************
                          ws_ftpimportfilterplugin.cpp  -  description
                             -------------------
    begin                : tis mar 19 2002
    copyright            : (C) 2002 by Bjrn Sahlstrm
    email                : kbjorn@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

//////////////////////////////////////////////////////
// Qt specific includes
#include <qdom.h>
#include <qdir.h>
#include <qstringlist.h>
//////////////////////////////////////////////////////
// KDE specific includes
#include <klocale.h>
#include <kconfig.h>
#include <kmdcodec.h>
#include <kmessagebox.h>
#include <kinstance.h>
#include <kgenericfactory.h>
#include <kdebug.h>
//////////////////////////////////////////////////////
// Application specific includes
#include "ws_ftpimportfilterplugin.h"

typedef KGenericFactory<WS_FTPImportFilterPlugin> WS_FTPImportFilterPluginFactory;
K_EXPORT_COMPONENT_FACTORY( libkbearwsftpimportfilter, WS_FTPImportFilterPluginFactory( "WS_FTPImportFilterPlugin" ) );
//-----------------------------------------------
WS_FTPImportFilterPlugin::WS_FTPImportFilterPlugin(QObject *parent, const char *name,const QStringList& )
	:	SiteImportFilterPluginIface(parent,name),
		m_hasError( false )
{
//	setXMLFile("ws_ftpimportfilterui.rc");
	KGlobal::locale()->insertCatalogue("kbear");
	m_domDocument.setContent( QString("<group label=\"%1\"/>").arg(i18n("WS_FTP import (Win)")) );
}
//-----------------------------------------------
WS_FTPImportFilterPlugin::~WS_FTPImportFilterPlugin(){
}
//-----------------------------------------------
QString WS_FTPImportFilterPlugin::getDomDocument() {
	return m_domDocument.toString();
}
//-----------------------------------------------
void WS_FTPImportFilterPlugin::import( const QString& fileName ) {
	if( fileName.isEmpty() || fileName.isNull() ) {
		KMessageBox::sorry( 0, i18n("You have to select a file to import."), i18n("No file") );
		m_hasError = true;
		emit progress( 100 );
		return;
	}
	int answer = KMessageBox::warningContinueCancel( 0,
					i18n("Currently this import filter can't import the passwords in this file.\n"
							"Because of this you have retype the passwords before using the bookmark."), i18n("Password") );
	if( answer == KMessageBox::Cancel ) {
		m_hasError = true;
		emit progress( 100 );
		return;
	}
	KConfig config( fileName, true, false, "HOME" );
	// First we fetch some global settings
	config.setGroup("_config_");
	QString email = config.readEntry( "MAILADDR", "anonymous@" );	

	QStringList siteList = config.groupList();
	float size = (float)siteList.count();
	if( size == 0 ) {
		invalidFileError( fileName );
		m_hasError = true;
		emit progress( 100 );
		return;
	}	
	int counter = 0;
	for( QStringList::Iterator it = siteList.begin(); it != siteList.end(); ++it ) {
		QString siteName = *it; // found groupname from WS_FTP.ini

		QDomNode siteNode;
		QDomElement parentElement = m_domDocument.documentElement();
		config.setGroup( siteName );
		QString tmp = config.readEntry("HOST", QString::null );  // we ignore the site if it hasn't any host
		if( tmp.isNull() )               // it seem as WS_FTP mix uppercase/lowercase so we have to check for both
			tmp = config.readEntry("host", QString::null );
		// first  check so the site has a host, if not ignore it
		if( ! tmp.isNull() || ! tmp.isEmpty() ) {  // had host
			// set label
			QDomElement siteElement = m_domDocument.createElement( "site" );
			siteElement.setAttribute( "label", siteName );			
			parentElement.appendChild( siteElement );	
			// set host
			QDomElement tmpElement = m_domDocument.createElement( "host" );
			QDomText txtNode = m_domDocument.createTextNode( tmp );
			tmpElement.appendChild( txtNode );
			siteElement.appendChild( tmpElement );	
			// set port
			tmpElement = m_domDocument.createElement( "port" );
			txtNode = m_domDocument.createTextNode( QString::number( 21 ) );
			tmpElement.appendChild( txtNode );
			siteElement.appendChild( tmpElement );	
			// set protocol
			tmpElement = m_domDocument.createElement( "protocol" );
			txtNode = m_domDocument.createTextNode( "ftp" );
			tmpElement.appendChild( txtNode );
			siteElement.appendChild( tmpElement );	
			// set remote directory
			tmp = config.readEntry("DIR", "/" );  // we ignore the site if it hasn't any host
			if( tmp == "/" )               // it seem as WS_FTP mix uppercase/lowercase so we have to check for both
				tmp = config.readEntry("dir", "/" );
			tmpElement = m_domDocument.createElement( "remote_path" );
			txtNode = m_domDocument.createTextNode( tmp );
			tmpElement.appendChild( txtNode );
			siteElement.appendChild( tmpElement );	
			// set local directory
			tmpElement = m_domDocument.createElement( "local_path" );
			txtNode = m_domDocument.createTextNode( QDir::homeDirPath() );
			tmpElement.appendChild( txtNode );
			siteElement.appendChild( tmpElement );	
			// set username
			tmp = config.readEntry("UID", "anonymous" );  // we ignore the site if it hasn't any host
			if( tmp == "anonymous" )               // it seem as WS_FTP mix uppercase/lowercase so we have to check for both
				tmp = config.readEntry("uid", "anonymous" );
			tmpElement = m_domDocument.createElement( "user" );
			txtNode = m_domDocument.createTextNode( tmp );
			tmpElement.appendChild( txtNode );
			siteElement.appendChild( tmpElement );	
			// set password
			if( tmp == "anonymous" ) {
				tmp = encodePassword( email );
			}
			else {
				tmp = config.readEntry("PWD", QString::null );  // we ignore the site if it hasn't any host
				if( tmp.isNull() )               // it seem as WS_FTP mix uppercase/lowercase so we have to check for both
					tmp = config.readEntry("pwd", QString::null );
			}
			tmpElement = m_domDocument.createElement( "pass" );
			txtNode = m_domDocument.createTextNode( tmp );
			tmpElement.appendChild( txtNode );
			siteElement.appendChild( tmpElement );	
			// set PASV
			int p = config.readNumEntry("PASVMODE", 1 );  // we ignore the site if it hasn't any host
			if( p == 1 )               // it seem as WS_FTP mix uppercase/lowercase so we have to check for both
				p = config.readNumEntry("pasvmode", 1 );
			if( p != 1 ) {
				tmpElement = m_domDocument.createElement( "disable_pasv" );
				siteElement.appendChild( tmpElement );	
			}
			// set description
			tmp = config.readEntry("COMMENT", QString::null );  // we ignore the site if it hasn't any host
			if( tmp.isNull() )               // it seem as WS_FTP mix uppercase/lowercase so we have to check for both
				tmp = config.readEntry("comment", QString::null );
			tmpElement = m_domDocument.createElement( "description" );
			txtNode = m_domDocument.createTextNode( tmp );
			tmpElement.appendChild( txtNode );
			siteElement.appendChild( tmpElement );	
		}
		emit progress( int(float(counter) / size * 100) );	
		counter++;	
	}	
	emit progress( 100 );
}
//-----------------------------------------------
void WS_FTPImportFilterPlugin::invalidFileError(const QString& fileName){
	KMessageBox::sorry( 0, i18n("The file: %1\nis either empty or it's not a valid WS_FTP bookmarks file.").arg(fileName), i18n("Invalid import file") );
}
//-----------------------------------------------
QString WS_FTPImportFilterPlugin::encodePassword( const QString& password ) {
	QString pass = password;
	QTextStream sStream( &pass, IO_ReadOnly );
	QCString bArray;
	sStream >> bArray;
	QCString result = KCodecs::base64Encode( bArray );	
	QString encodedPass = result.data();
	return encodedPass;
}
//-----------------------------------------------
#ifndef NO_INCLUDE_MOCFILES
#include "ws_ftpimportfilterplugin.moc"
#endif
