#include "vistabar.h"
#include "settings.h"
#include "qapplication.h"
#include "qcursor.h"
#include "spinxbutton.h"

vista::vista (QWidget * parent, const char *name, WFlags fl):
QWidget (parent, name,
	 WStyle_Customize | WRepaintNoErase | WStyle_NoBorder |
	 WDestructiveClose  | WStyle_StaysOnTop  |  Qt::WPaintDesktop )
{


  parentRef = parent;
  readConfig ();

/*start top border */

 /*end top border */

  backbg = new QLabel (this, "backbg");
  backbg->setPixmap (QImage (bbg));
  backbg->setScaledContents (TRUE);

  tab = new QWidgetStack (this, "tabWidget2");
  tab->setPaletteBackgroundPixmap (QImage (bbg));


  tabindex = new KbfxSpinxListBox (this, "tabindex");
  widgetarray[0] = new QWidget (tab, "tab");
  tabindex->setVariableHeight (TRUE);
  tabindex->setRowMode (QListBox::Variable);

  topbg = new KbfxSpixTop (this, "topbg");
  topbg->setPixmap (QImage (top));
  topbg->setScaledContents (TRUE);


/* icon view properties */
  list1 = new KbfxSpinxListBox (widgetarray[0], "List view");
  tab->addWidget (widgetarray[0], 0);
  VistaListBoxItem *home = new VistaListBoxItem ();
  home->setLabelText (new QString ("Recently Used"));
  tabindex->insertItem (home, 0);
  tabindex->setType(1);

/* end icon view */

  botbg = new QLabel (this, "botbg");
  botbg->setPixmap (QImage (bot));
  botbg->setScaledContents (TRUE);

  place = new QWidget (this, "tm");
  listbar = new KHistoryCombo (place, "search");
  logoutbtn = new SpinxButton (botbg, "Logout");
  lockbtn = new   SpinxButton (botbg, "lock");

  connectSignalsWithSlots (parent);
  createApplicationList ();
  languageChange ();
  clearWState (WState_Polished);
  list1->setSelectionMode (QListBox::Single);

  zoomWidth = 32;
  zoomHeight = 32;
}



void
vista::animate ()
{


}

void
vista::closeMenu (QListBoxItem * item)
{


  parentRef->hide ();

}

void
vista::connectSignalsWithSlots (QWidget * ref)
{

  connect (list1, SIGNAL (onItem (QListBoxItem *)), this,
	   SLOT (mouseOverItemSlot (QListBoxItem *)));

  connect (list1, SIGNAL (clicked (QListBoxItem *)),
	   this, SLOT (startApp (QListBoxItem *)));

  connect (list1, SIGNAL (clicked (QListBoxItem *)), this,
	   SLOT (closeMenu (QListBoxItem *)));

  connect (listbar, SIGNAL (returnPressed (const QString &)), this,
	   SLOT (startApp (const QString &)));

  connect (listbar, SIGNAL (returnPressed ()), ref, SLOT (hide ()));


  connect (tabindex, SIGNAL (raiseNow (int)), tab,
	   SLOT (raiseWidget (int)));
  connect (tabindex, SIGNAL (raiseNow (int)), tabindex,
	   SLOT (scrollRest(int)));
 
  
/*  
   connect (list1, SIGNAL (clicked (QListBoxItem *)), this,
	   SLOT (startAction (QListBoxItem *)));
*/

  connect (list1, SIGNAL (onItem (QListBoxItem *)), this,
	   SLOT (listItemZoomIn (QListBoxItem *)));
//  connect (list1, SIGNAL (moveUp (QListBoxItem *)), this,
//	   SLOT (scroll (QListBoxItem *)));
  connect (logoutbtn, SIGNAL (clicked ()), this, SLOT (logoutSlot ()));
  connect (lockbtn, SIGNAL (clicked ()), this, SLOT (lockSlot ()));

  connect (topbg,SIGNAL(scroll(int)),list1,SLOT(scroll(int)));
  connect (list1,SIGNAL(showScrollBar()),topbg,SLOT(scrollArrowsOn()));

}



void
vista::logoutSlot ()
{
  DCOPRef m_kdesktopKDesktopIface ("kdesktop", "KDesktopIface");
  m_kdesktopKDesktopIface.call ("logout()");


}


void
vista::lockSlot ()
{


  DCOPRef m_kdesktopKScreensaverIface ("kdesktop", "KScreensaverIface");
  m_kdesktopKScreensaverIface.call ("lock()");

	parentRef->hide();


}


void
vista::readConfig ()
{
  static_cast < KConfigSkeleton * >(KbfxCfg::self ())->readConfig ();
  qDebug ("Reading Theme");
  qDebug (KbfxCfg::themeTop ());

}

void
vista::listItemZoomIn (QListBoxItem * item)
{

  if (item == NULL)
    return;
//qDebug("Mouse Enter");
  QListBox *tem = item->listBox ();

  tem->setSelected (item, true);
  tem->setCurrentItem (item);

  int scrollDelta = (-22);

  if (item->next () == 0)
    scrollDelta = 22;

}

/*
void
vista::scroll (int delta)
{

QWheelEvent we ( QCursor::pos(), delta , Qt::NoButton );
QApplication::sendEvent( tabindex, &we );

qDebug("I got the signal scrolling");

}
*/


void
vista::createApplicationList ()
{

  int j = 1;
  QString prv = "";
  QString kmenueditroot = "";

  KServiceGroup::Ptr group = KServiceGroup::root ();


  if (!group || !group->isValid ())
    return;

  KServiceGroup::List list = group->entries ();

  for (KServiceGroup::List::ConstIterator it = list.begin ();
       it != list.end (); it++)
    {
      KSycocaEntry *p = (*it);
      if (p->isType (KST_KService))
	{

	}
      else if (p->isType (KST_KServiceGroup))
	{

	  KServiceGroup *g = static_cast < KServiceGroup * >(p);
	  KServiceGroup::List list2 = g->entries ();
	  widgetarray[j] = new QWidget (tab, tr ("KDE tools"));
	  widgetarray[j] = new QWidget (tab, g->name ());
	  tab->addWidget (widgetarray[j], j);
	  kmenueditroot = "";
	  kmenueditroot += g->name ();
	  qDebug (kmenueditroot);
	  if (g->name ().startsWith ("."))
	    {

	      VistaListBoxItem *tmp1 = new VistaListBoxItem ();
	      tmp1->setLabelText (new QString (tr ("KDE Tools")));
	      tabindex->insertItem (tmp1, j);

	    }
	  else
	    {

	      VistaListBoxItem *temp2 = new VistaListBoxItem ();
	      temp2->
		setLabelText (new QString (tr (g->name ().remove ('/'))));
	      tabindex->insertItem (temp2, j);

	    }
	  listarray[j] = new KbfxSpinxListBox (widgetarray[j], "List view");
	  for (KServiceGroup::List::ConstIterator it = list2.begin ();
	       it != list2.end (); it++)
	    {
	      KSycocaEntry *p = (*it);
	      if (p->isType (KST_KService))
		{
		  KService *s = static_cast < KService * >(p);

		  if (!listarray[j]->findItem (s->name (), 0))
		    addApplication (listarray[j], s->icon (), s->name (),
				    s->exec (), s->comment ());
		  prv = s->name ();
		  listbar->addToHistory (s->exec ());
		}

	    }


	  addApplication (listarray[j], "add", "Add More To " + kmenueditroot,
			  "kmenuedit /" + kmenueditroot.remove ("/"),
			  "Add/Edit Applications ");

	  connect (listarray[j], SIGNAL (onItem (QListBoxItem *)), this,
		   SLOT (mouseOverItemSlot (QListBoxItem *)));
	  connect (listarray[j], SIGNAL (clicked (QListBoxItem *)),
		   this, SLOT (startApp (QListBoxItem *)));

	  connect (listarray[j], SIGNAL (clicked (QListBoxItem *)), this,
		   SLOT (closeMenu (QListBoxItem *)));

	  connect (listarray[j], SIGNAL (onItem (QListBoxItem *)), this,
		   SLOT (listItemZoomIn (QListBoxItem *)));

	 connect (tabindex,SIGNAL(raiseNow(int)),listarray[j],SLOT(scrollRest(int))); 
	 connect (topbg,SIGNAL(scroll(int)),listarray[j],SLOT(scroll(int))); 
  	 connect (listarray[j],SIGNAL(showScrollBar()),topbg,SLOT(scrollArrowsOn()));
  	 connect (listarray[j],SIGNAL(hideScrollBar()),topbg,SLOT(scrollArrowsOff()));
	  	  j++;

	  numberoftabs = j;

	}

    }

  listbar->addToHistory ("kcontrol");
}


void
vista::listboxMouseOverSlot (QListBoxItem * item)
{
  tabindex->setSelected (item, FALSE);
}


vista::~vista ()
{

}

void
vista::addApplication (QListBox * view, QString icon, QString action,
		       QString exec, QString comment)
{

  if (history.contains (action) <= 0)
    {

      KIconLoader *iconload = KGlobal::iconLoader ();
      QString iconfile = iconload->iconPath (icon, KIcon::Desktop, false);
      VistaListBoxItem *Item = new VistaListBoxItem ();
      Item->setLabelText (new QString (action));
      QPixmap iconbg (iconfile);

      if (iconbg.height () < 32 || iconbg.height () > 32)
	{
	  QImage img (iconfile);
	  img = img.smoothScale (32, 32);
	  iconbg = QPixmap (img);
	}
      Item->setHeight (iconbg.height ());
      Item->setWidth (250);
      Item->setLabelIcon (icon);
      Item->setLabelIcon (iconbg);
      Item->setExec (exec);
      Item->setComment (comment);
      Item->setTilePixmap (tileNormal);
      Item->setTileHoverPixmap (tileHover);
      view->insertItem (Item, 0);



    }

}


void
vista::KappbarSetTileImages (QPixmap normal, QPixmap hover, QPixmap rhsnormal,
			     QPixmap rhshover)
{
  tileNormal = normal;
  tileHover = hover;
  RHS_tileNormal = rhsnormal;
  RHS_tileHover = rhshover;

  if (tileNormal.isNull ())
    tileNormal.convertFromImage (tilenormal);
  if (tileHover.isNull ())
    tileHover.convertFromImage (tilehover);


}

void
vista::languageChange ()
{

//FIXME:remove this function 

}


void
vista::startApp (QListBoxItem * item)
{

  if (item == NULL)
    return;


  VistaListBoxItem *_item = (VistaListBoxItem *) item;
//item->listbox();
//qDebug(_item->getIcon());
  QString app = _item->getExec ();
  if (app.contains ("dcop"))
    {

      DCOPRef m_kickerkbfxInterface ("kicker", "kbfxInterface");
      m_kickerkbfxInterface.call ("notifyConfigChange()");

    }

  if (app.contains ("kmenuedit"))
    {
      qDebug ("Menu Edit called");
  //    tabindex->setCurrentItem (0);
	tab->raiseWidget (0);
      KRun::runCommand (app);
      addApplication (list1, "knewstuff", "Need to Rebuild Spinx", "dcop",
		      "Click Here to Reload");
      return;
    }
  else
    {
      addApplication (list1, _item->getIcon (), *_item->getText (),
		      _item->getExec (), _item->getComment ());
      history += *_item->getText ();
    }

  qDebug (history);

  QString search (*_item->getText ());

  KServiceGroup::Ptr group = KServiceGroup::root ();
  if (!group || !group->isValid ())
    return;

  KServiceGroup::List list = group->entries ();

  for (KServiceGroup::List::ConstIterator it = list.begin ();
       it != list.end (); it++)
    {
      KSycocaEntry *p = (*it);
      if (p->isType (KST_KService))
	{
	  KService *s = static_cast < KService * >(p);
	  if (search == s->name ())
	    {
	      KURL desktopfile;
	      QString path (s->desktopEntryPath ());
	      desktopfile.setPath (path);
	      KRun *exec = new KRun (desktopfile);
	      addApplication (list1, s->icon (), s->name (), s->exec (),
			      s->comment ());
	      return;
	    }
	}
      else if (p->isType (KST_KServiceGroup))
	{
	  KServiceGroup *g = static_cast < KServiceGroup * >(p);
	  KServiceGroup::List list2 = g->entries ();

	  for (KServiceGroup::List::ConstIterator it = list2.begin ();
	       it != list2.end (); it++)
	    {
	      KSycocaEntry *p = (*it);
	      if (p->isType (KST_KService))
		{
		  KService *s = static_cast < KService * >(p);


		  if (search == s->name ())
		    {

		      list1->update ();
		      KURL desktopfile;
		      QString path (s->desktopEntryPath ());
		      if (!path.startsWith ("/"))
			{

			  QString apppath =
			    KStandardDirs ().findResource ("apps", path);
			  desktopfile.setPath (apppath);
			}
		      else
			{
			  desktopfile.setPath (path);
			}
		      KRun *exec = new KRun (desktopfile);
		     // tabindex->setCurrentItem (0);
			tab->raiseWidget (0);

		      return;

		    }

		}
	    }

	}
    }




}


void
vista::KAppBarSetTheme (QPixmap maintop, QPixmap mainbg, QPixmap tabbg,
			QPixmap mainbot, QPixmap mask, QPixmap listboxbg,
			QPixmap logoutbg,QPixmap logoutbghover, QPixmap lockbghover, QPixmap lockbg, QPixmap listbg,
			QPixmap find,QPixmap dudebox)
{


  if (find.isNull ())
    find.convertFromImage (find_xpm);

  if (logoutbg.isNull ())
    logoutbg.convertFromImage (logout_xpm);

  if (lockbg.isNull ())
    lockbg.convertFromImage (lock_xpm);

  if (listboxbg.isNull ())
    listboxbg.convertFromImage (listboxbg_xpm);

  if (listbg.isNull ())
    listbg.convertFromImage (appfind);


  int widthof;
  int heightof;
  if (!mask.isNull ())
    {

      widthof = mask.width ();
      heightof = mask.height ();
      setMinimumWidth (widthof);
      setMinimumHeight (heightof);
      resize (QSize (mask.width (), mask.height ()).
	      expandedTo (minimumSizeHint ()));
    }
  else
    {
      widthof = 300;
      heightof = 400;
      setMinimumWidth (300);
      setMinimumHeight (400);
      resize (QSize (300, 400).expandedTo (minimumSizeHint ()));
    }


  tab->setFrameShape (QFrame::NoFrame);
  tabindex->setFrameShape (QFrame::NoFrame);
  tabindex->setHScrollBarMode (QScrollView::AlwaysOff);

  list1->setFrameShape (QFrame::NoFrame);
  list1->setHScrollBarMode (QScrollView::AlwaysOff);


  topbg->setGeometry (QRect (0, 0, widthof, maintop.height ()));
  backbg->
    setGeometry (QRect (0, maintop.height (), widthof, mainbg.height ()));
  botbg->
    setGeometry (QRect
		 (0,
		  ((heightof - (topbg->height () + mainbot.height ())) +
		   (topbg->height ())), widthof, mainbot.height ()));
  tab->
    setGeometry (QRect
		 (((mask.width () - (tabbg.width ())) / 2), maintop.height (),
		  (tabbg.isNull ())? widthof - 40 : tabbg.width (),
		  listboxbg.height () + 5));
  //  heightof - (topbg->height () + botbg->height () + 5)));

/*
  tabindex->
    setGeometry (QRect
		 ((mask.width () - (tabbg.width ())) / 2,
		  maintop.height (),
		  (tabbg.isNull ())? widthof - 40 : tabindex->maxItemWidth (),
		  mainbg.height ()));
*/

  tabindex->
    setGeometry (QRect
		 ((mask.width () - (tabbg.width ())) / 2,
		  maintop.height (),
		  tabindex->maxItemWidth(),
		  mainbg.height ()));


  list1->
    setGeometry (QRect
		 (tabindex->width (), 0,
		 (tab->width () - tabindex->width ()), listboxbg.height ()));
  if (!listboxbg.isNull ())
    //tabindex->setPaletteBackgroundPixmap(listboxbg);
   // logoutbtn->setPaletteBackgroundPixmap (logoutbg);
 /// lockbtn->setPaletteBackgroundPixmap (lockbg);

  logoutbtn->setPixmap(logoutbg,logoutbghover);
  lockbtn->setPixmap(lockbg,lockbghover);
// listbar->setPaletteBackgroundPixmap (listbg);
// listbar->setGeometry (QRect (0, 0, (list1->width () + tabindex->width())-(logoutbtn->width()+lockbtn->width()) , place->height ()));

//  place->
  //   setGeometry (QRect
//               ((mask.width () - (tabbg.width ())) / 2, ( mask.height()-mainbot.height()) +10,
//                list1->width ()+tabindex->width(), listbar->height ()));

  if (logoutbg.isNull ())
    {
   //  qDebug ("logout Button Pixmap not found or not valid");
      //logoutbg.convertFromImage(QImage(logout));
    }
  place->
    setGeometry (QRect
		 (find.width (), (mask.height () - mainbot.height ())+10 ,
		  (botbg->width()-(logoutbg.width()+lockbg.width()))-30, find.height()));

  listbar->setGeometry (QRect (0, 0, place->width (), place->height ()));

  logoutbtn->
    setGeometry (QRect
		 (mask.width () - (lockbg.width () + logoutbg.width ()), 0,
		  logoutbg.width (), logoutbg.height ()));
  lockbtn->
    setGeometry (QRect
		 (mask.width () - lockbg.width (), 0, lockbg.width (),
		  lockbg.height ()));
  QWidget *findit = new QWidget (this, tr ("Find %>"));
  findit->setBackgroundPixmap (find);

  findit->
    setGeometry (QRect
		 (4, (mask.height () - mainbot.height ()) + 10, find.width (),
		  place->height () ));
 if(find.mask())
	{
 findit->setMask( *find.mask() );
	}

  int x = 1;
  for (; x < numberoftabs; x++)
    {

      listarray[x]->
	setGeometry (QRect
		     ((tabindex->width ()), 0,
		      ((tab->width () - tabindex->width ())),
		      mainbg.height ()));

      listarray[x]->setFrameShape (QFrame::NoFrame);
      listarray[x]->setHScrollBarMode (QScrollView::AlwaysOff);

      int count = listarray[x]->count ();
      for (int i = 0; i < count; i++)
	{
	  QListBoxItem *_item = listarray[x]->item (i);
	  VistaListBoxItem *_it = (VistaListBoxItem *) _item;
	  _it->setTilePixmap (tileNormal);
	  _it->setTileHoverPixmap (tileHover);
	}
      if (!listboxbg.isNull ())
	listarray[x]->setPaletteBackgroundPixmap (listboxbg);

      if (count == 0)
	{

//      tabindex->removeItem(x);
//      tab->removeWidget(widgetarray[x]);
//      numberoftabs--;
	}

    }

  if (!listboxbg.isNull ())
    list1->setPaletteBackgroundPixmap (listboxbg);


/*********************/
//home menu
  int count = list1->count ();
  for (int i = 0; i < count; i++)
    {
      QListBoxItem *_item = list1->item (i);
      VistaListBoxItem *_it = (VistaListBoxItem *) _item;
      _it->setTilePixmap (tileNormal);
      _it->setTileHoverPixmap (tileHover);
    }


/****************/

  int homecount = tabindex->count ();
  for (int i = 0; i < homecount; i++)
    {
      QListBoxItem *_item = tabindex->item (i);
      VistaListBoxItem *_it = (VistaListBoxItem *) _item;
      _it->setTilePixmap (RHS_tileNormal);
      _it->setTileHoverPixmap (RHS_tileHover);
      _it->setType (1);
    }

//Get the user name 

  KUser *user = new KUser ();
  QString logInName (user->loginName ());
  KIconLoader *iconload = KGlobal::iconLoader ();
  //QString iconfile = iconload->iconPath (logInName, KIcon::User, false);
  QImage
    UserImage (locate
	       ("data", "/home/" + user->loginName () + "/.face.icon"));
  UserImage = UserImage.smoothScale (48, 48);
  
  topbg->setUserImage(QPixmap(UserImage));
  if(dudebox.isNull())
  topbg->setBoundBox(menu_top_image_person);
  else
  topbg->setBoundBox(dudebox);
  //QImage dudeBox (menu_top_image_person);
 
   
/*
*/

  topbg->setPixmap ((maintop));
  topbg->repaint();
  backbg->setPixmap ((mainbg));
  botbg->setPixmap ((mainbot));
  tab->setPaletteBackgroundPixmap (tabbg);


//  tabindex->repaint();
  barheight = heightof;
  resetpending = 0;

}


//DEPRICATED:NEEDs to Remove this 
void
vista::mouseOverItemSlot (QListBoxItem * item)
{

  VistaListBoxItem *_item = (VistaListBoxItem *) item;

}



void
vista::startAction (QListBoxItem * it)
{

  if (it == NULL)
    return;
  VistaListBoxItem *_it = (VistaListBoxItem *) it;
  QString action (*_it->getText ());
  qDebug ("Action");
  qDebug (action);

  if (action == "Logout")
    {
      DCOPRef m_kdesktopKDesktopIface ("kdesktop", "KDesktopIface");
      m_kdesktopKDesktopIface.call ("logout()");
      qDebug ("Action Logout");
      return;
    }
  else if (action == "kcontrol")
    {

      //start kcontrol

    }
  else if (action == "lock")
    {


      DCOPRef m_kdesktopKScreensaverIface ("kdesktop", "KScreensaverIface");
      m_kdesktopKScreensaverIface.call ("lock()");
      qDebug ("Desktop Lock called");


    }
  else
    {
      this->hide ();
      return;

    }
  this->hide ();
}


void
vista::startApp (const QString & x)
{
  KRun::runCommand (x);
}

void
vista::textSlot (const QString & x)
{
}
