/***************************************************************************
 *   Copyright (C) 2005 by Siraj Razick                                    *
 *   siraj@kdemail.net                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "kbfx_vista_button.h"
//#include "../imagesource/kbfx.xpm"
#include <stdio.h>
#include <kpixmapeffect.h>
#include <kimageeffect.h>
#include <qbutton.h>
#include <qtimer.h>
#include "kbfxconfig.h"

kbfx_vista_button::kbfx_vista_button (QWidget * parent, const char *name):
QLabel (parent, name,
	Qt::WStaticContents | Qt::WNoAutoErase |Qt::WPaintDesktop)
{

  setLineWidth (0);
  setScaledContents (false);
  fxon = false;
  QTimer *t = new QTimer (this);
  connect (t, SIGNAL (timeout ()), SLOT (update ()));
  t->start (150, FALSE);

  _anime_on = false;
  _anime_timer = new QTimer (this);
  connect (_anime_timer, SIGNAL (timeout ()), this, SLOT (updateMovie ()));

}

void
kbfx_vista_button::kbfx_vista_button_setFx (bool t)
{

  fxon = t;
//  _anime_on = true;
}



void
kbfx_vista_button::paintEvent (QPaintEvent * pe)
{

  const QRect r = pe->rect ();
  static QPixmap pixmap;
  pixmap.resize(r.size());
  pixmap.fill(this, r.topLeft());


  QPainter p;
  if (!current_skin.isNull ())
    {
      p.begin (&pixmap,this);
      p.translate(-r.x(), -r.y());

//	const QPixmap * delpix = this->paletteBackgroundPixmap ();

//	if(delpix != NULL)
//		p.drawPixmap(r,*delpix);
//	else
//	{
	//qDebug("delpix is NULL");
//QPixmap tmp(r.size());
//	tmp.fill(this,r.topLeft());
//	p.drawPixmap(r,tmp);
//	}
	p.drawPixmap(r,current_skin);
	p.end ();
	
	bitBlt(this, r.x(), r.y(), &pixmap, 0, 0,
       r.width(), r.height());
    }

}


void
kbfx_vista_button::updateMovie ()
{

  if (current_anime == NULL)
    return;

  if (_anime_on)
    {
      current_skin = current_anime->framePixmap ();
      kbfx_vista_button_setPixmap (current_skin);
    }

}

void
kbfx_vista_button::timerEvent (QTimerEvent * e)
{
}

int
kbfx_vista_button::kbfx_vista_button_setPixmap (QPixmap skin)
{

//Apply Image Effects for Pixmap
//  QImage tmp = skin.convertToImage ();
//  tmp = KImageEffect::channelIntensity (tmp, 0.0, KImageEffect::Red);
//  skin.convertFromImage (tmp);

  QSize m_size;
  if (!skin.isNull ())
    {
      if (current_skin.size () != skin.size ())
	this->resize (skin.width (), skin.height ());
      if (_anime_on && current_skin.mask ())
	{
	  this->setMask (*current_skin.mask ());
	  this->resize (skin.width (), skin.height ());
	}
      current_skin = skin;
      //setErasePixmap(current_skin);yuckk!
      if (_anime_on)
	{
	  resize (current_skin.width (), current_skin.height ());
	  emit sizechange ();
	}
      this->update ();
    }
  else
	{
  //  current_skin = QImage (kbfx);
	}
	this->update();	
   //this->setPixmap(current_skin);
 //  this->repaint();
  return 1;
}


void
kbfx_vista_button::kbfx_vista_button_setMovie (QMovie * mov)
{

  _anime_timer->stop ();
  current_anime = mov;
  _anime_timer->start (30, FALSE);

}



int
kbfx_vista_button::kbfx_vista_button_loadSkins (QString normal, QString hover,
						QString pressed)
{

//FIX animation code
  QFileInfo m_file_normal (normal);
  QFileInfo m_file_hover (hover);
  QFileInfo m_file_pressed (pressed);

  normal_path = normal;
  over_path = hover;
  pressed_path = pressed;

  if (m_file_normal.extension (FALSE) == "gif")
    {
      normal_anime = new QMovie (normal);
      normal_skin = normal_anime->framePixmap ();

      _anime_timer->start (30, FALSE);
      if (_anime_on && normal_skin.mask ())
	this->setMask (*normal_skin.mask ());
      _anime_on = true;
    }
  else
    {
      _anime_on = false;
      _anime_timer->stop ();
      normal_skin = QImage (normal);
      if (normal_skin.mask () && _anime_on)
	this->setMask (*normal_skin.mask ());
    }

  if (m_file_hover.extension (FALSE) == "gif")
    {
      hover_anime = new QMovie (hover);
      over_skin = hover_anime->framePixmap ();

    }
  else
    {
      over_skin = QImage (hover);
    }

  if (m_file_hover.extension (FALSE) == "gif")
    {
      pressed_anime = new QMovie (pressed);
      if (pressed_anime != NULL)
	pressed_skin = pressed_anime->framePixmap ();

    }
  else
    {
      pressed_skin = QImage (pressed);
    }


  if (normal_skin.isNull ())
    {
  //    normal_skin = QImage (kbfx);

    }

//  over_skin = QImage (hover);

  if (over_skin.isNull ())
    {
      over_skin = QImage (normal);

    }
//  pressed_skin = QImage (pressed);

  if (pressed_skin.isNull ())
    {
      pressed_skin = QImage (normal);

    }
  this->repaint ();
  emit skinLoadComplete ();

  return 1;

}


kbfx_vista_button::~kbfx_vista_button ()
{


}

void
kbfx_vista_button::skinLoadCompleteSlot ()
{
  if (_anime_on && !normal_skin.isNull ())
    kbfx_vista_button_setMovie (normal_anime);
  else
    kbfx_vista_button_setPixmap (normal_skin);

  emit sizechange ();
}


void
kbfx_vista_button::onMouseOverSlot ()
{
  if (_anime_on && over_path != "")
    kbfx_vista_button_setMovie (hover_anime);
  else
    kbfx_vista_button_setPixmap (over_skin);
}


void
kbfx_vista_button::onMouseLeaveSlot ()
{
  if (_anime_on && normal_path != "")
    kbfx_vista_button_setMovie (normal_anime);
  else
    kbfx_vista_button_setPixmap (normal_skin);
}

void
kbfx_vista_button::onMouseClickSlot ()
{
  if (_anime_on && pressed_path != "")
    kbfx_vista_button_setMovie (pressed_anime);
  else
    kbfx_vista_button_setPixmap (pressed_skin);
}

void
kbfx_vista_button::startMenuDone (int callId, const QCString & replyType,
				  const QByteArray & replyData)
{
  kbfx_vista_button_setPixmap (normal_skin);
}

#include "kbfx_vista_button.moc"
