/***************************************************************************
 *   Copyright (C) 2004-2009 by Thomas Fischer                             *
 *   fischer@unix-ag.uni-kl.de                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef KBIBTEXWEBQUERYGOOGLESCHOLAR_H
#define KBIBTEXWEBQUERYGOOGLESCHOLAR_H

#include <qstringlist.h>
#include <qbuffer.h>

#include <kurl.h>

#include <fileimporterbibtex.h>
#include <webquery.h>

namespace KBibTeX
{
    /**
     @author Thomas Fischer <fischer@unix-ag.uni-kl.de>
    */
    class WebQueryGoogleScholarWidget : public WebQueryWidget
    {
        Q_OBJECT
    public:
        WebQueryGoogleScholarWidget( QWidget *parent, const char *name = 0 );
    };

    /**
     @author Thomas Fischer <fischer@unix-ag.uni-kl.de>
    */
    class WebQueryGoogleScholar : public WebQuery
    {
        Q_OBJECT
    public:
        WebQueryGoogleScholar( QWidget* parent );
        virtual ~WebQueryGoogleScholar();

        void query();

        QString title();
        QString disclaimer();
        QString disclaimerURL();

        WebQueryWidget *widget();

    protected:
        void cancelQuery();

    private slots:
        void slotData( KIO::Job *, const QByteArray &data )
        {
            m_transferJobBuffer->writeBlock( data.data(), data.size() );
        };

        /** Google Scholar's start page has been loaded */
        void slotFinishedStartpage( KIO::Job *job );
        /** Settings page has been loaded */
        void slotFinishedLoadingSettings( KIO::Job *job );
        /** Settings page upload and search mask loaded */
        void slotFinishedSavingSettings( KIO::Job *job );
        /** page with results loaded */
        void slotFinishedReceivingResultOverview( KIO::Job *job );

    private:
        WebQueryGoogleScholarWidget *m_widget;

        bool m_abort;
        QString m_searchTerm;
        int m_numberOfResults;
        BibTeX::FileImporterBibTeX *m_importer;
        bool m_originalEnableCookies;
        bool m_originalSessionCookies;
        QMap <QString, QString> m_originalCookieMap;
        QString m_originalCookieGlobalAdvice;

        KIO::TransferJob *m_transferJob;
        QBuffer *m_transferJobBuffer;

        /** load KDE's cookie configuration, store values, and reset with Google-friendly values */
        void readAndChangeConfig();
        /** restore previous configuration values by saving old cookie configuration */
        void restoreConfig();

        /** extract text from a QBuffer object */
        QString textFromBuffer( QBuffer *buffer );

        /** parse HTML code and get all key-value pairs from <input..> and <select><option ...></select> */
        QMap <QString, QString> evalFormFields( const QString &htmlCode );

        /** glue together URL from key-value pairs in form */
        QString formFieldsToUrl( const QString &prefix, const QMap<QString, QString> &keyValues );
    };

}

#endif
