/***************************************************************************

   Copyright (C) 2007 Antonio Aloisio <gnuton@gnuton.org>
   Copyright (C) 2008 Christian Weilbach <christian_weilbach@web.de>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the
   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
 ***************************************************************************/

#include "profilelist.h"

#include <QFile>
#include <QStringList>

#include <kinputdialog.h>
#include <kconfigdialog.h>
#include <kstandarddirs.h>

#include "profileconfig.h"
#include "profileconfigdialog.h"

#define DIR_TO_SAVE_ENTRIES "entries/"
#define DIR_TO_SAVE_MEDIA "media/"

namespace KBlogger
{

ProfileList::ProfileList( QWidget* parent ): QWidget(parent)
{
    kDebug();
    setupUi(this);
    populateList();

    connect(addButton, SIGNAL(clicked()), SLOT(addAccount()));
    connect(modifyButton, SIGNAL(clicked()), SLOT(modifyAccount()));
    connect(delButton, SIGNAL(clicked()), SLOT(delAccount()));
}

ProfileList::~ProfileList()
{
    kDebug();
}

void ProfileList::populateList()
{
    //ProfileListTree
    QStringList groupList;
    QList<QTreeWidgetItem *> items;

    //TODO Move this code ---BEGIN--
    profileConfig *mProfileconfig = profileConfig::prefs("THIS_ACCOUNT_DOESNT_EXIST");
    groupList = mProfileconfig->config()->groupList();
    kDebug () <<  groupList << endl;
    groupList = groupList.filter( QRegExp("^Account_"));
    groupList.replaceInStrings(QRegExp("^Account_"), QString());
    //---END--

    ProfileListTree->clear();

    for (int i = 0; i < groupList.size() ; ++i)
        items.append(new QTreeWidgetItem((QTreeWidget*)0,
                                         QStringList(groupList.at(i))));
    ProfileListTree->insertTopLevelItems(0, items);
    if (!items.isEmpty()) {
        ProfileListTree->setCurrentItem(items.last());
    }
}

void ProfileList::addAccount()
{
    QStringList groupList;
    QString newAccount;
    QRegExp testRegExp("[.a-z0-9A-Z]+");
    QValidator* validator = new QRegExpValidator(testRegExp, this);

    newAccount = KInputDialog::getText(
                     i18n("Add a new profile"),
                     i18n("Insert here your new account name:"),
                     QString(), 0, this, validator);
    kDebug() << newAccount << endl;

    //TODO Move this code -begin-
    profileConfig *mProfileconfig = profileConfig::prefs("THIS_ACCOUNT_DOESNT_EXIST");
    groupList = mProfileconfig->config()->groupList();
    //TODO Move this code -end-

    //test TODO
    if (newAccount.isEmpty()) return;

    //create account
    mProfileconfig = profileConfig::prefs(newAccount.prepend("Account_"));
    mProfileconfig->writeConfig();
    modifyAccount(newAccount);
    populateList();
}

void ProfileList::delAccount()
{
    QTreeWidgetItem *mCurrentTreeItem;
    profileConfig *mProfileconfig;

    //Get Account name
    mCurrentTreeItem = ProfileListTree->currentItem();
    if (!mCurrentTreeItem) return;
    QString accountName = mCurrentTreeItem->text(0);

    QString account( accountName );
    account.prepend("Account_");
    kDebug() << account << endl;

    //Delete Account in the config file.
    mProfileconfig = profileConfig::prefs(account);
    mProfileconfig->setDefaults();
    // remove entries
    QString entriesFilename = QString(accountName).prepend(DIR_TO_SAVE_ENTRIES);
    QStringList list;
    list << "-sent" << "-local" << "-trash";
    QStringList::ConstIterator it = list.begin();
    QStringList::ConstIterator end = list.end();
    for( ; it != end; it++ ){
        QString entryFilenameToRemove( entriesFilename );
        entryFilenameToRemove.append( *it );
        QString entryFileToRemove = KStandardDirs::locateLocal("appdata", entryFilenameToRemove , true);
        QFile entryFile( entryFileToRemove );
        if( !entryFile.remove() )
            kError() << "Could not remove: " << entryFileToRemove;
    }
    // remove media
    QString mediaFilename = QString(accountName);
    mediaFilename.prepend(DIR_TO_SAVE_MEDIA);
    QString mediaFileToRemove = KStandardDirs::locateLocal("appdata", mediaFilename, true);
    QFile mediaFile( mediaFileToRemove );
    if( !mediaFile.remove() )
        kError() << "Could not remove: " << mediaFileToRemove;

    mProfileconfig->deletePrefs(account);
    mProfileconfig->writeConfig();

    //Refresh the blogname list (QListWidget)
    populateList();
}

void ProfileList::modifyAccount( QString account )
{
    KConfigDialog *dialog;
    ProfileConfigDialog *mProfileconfigDialog;
    profileConfig *mProfileconfig;
    QTreeWidgetItem *mCurrentTreeItem;

    //If account is empty, get account from selected QListWidget item
    if ( account.isEmpty()) {
        mCurrentTreeItem = ProfileListTree->currentItem();
        if (!mCurrentTreeItem) return;
        account = mCurrentTreeItem->text(0);
    }

    //"Account_" string prepend every accountname in the profile file.
    if ( account.left(8) != "Account_" )
        account = account.prepend("Account_");
    kDebug() << account;

    //Create Profile Config object
    mProfileconfig = profileConfig::prefs(account);

    if ( KConfigDialog::showDialog( "profiles" ) )  {
        return;
    }
    dialog = new KConfigDialog(this, "profiles", mProfileconfig);
    mProfileconfigDialog = new ProfileConfigDialog( dialog );
    dialog->setFaceType(KPageDialog::Plain);

    //Read data from ~/.kde4/share/config/kblogger-profilerc file
    //and fills any kfg_ fields in mProfileconfigDialog
    dialog->addPage(mProfileconfigDialog, account.replace("_", ": ") , "system-users");

    //Now kfg_url is set, so profileconfigdialog is able to read password from wallet
    //using kfg_url->text() as key.
    mProfileconfigDialog->readPasswordFromWallet();

    dialog->setAttribute( Qt::WA_DeleteOnClose );
    dialog->exec();
}

} //namespace kblogger
#include "profilelist.moc"
