/***************************************************************************
 *   Copyright (C) 2005 by Christian Weilbach   *
 *   christian_weilbach@web.de   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <qcheckbox.h>

#include <klineedit.h>
#include <klocale.h>
#include <ktextedit.h>
#include <kmessagebox.h>
#include <kcombobox.h>
#include <kdebug.h>

#include "kbloggereditor.h"
#include "API_Blog.h"


KBloggerEditor::KBloggerEditor( KBlog::APIBlog* backend, QWidget* parent, const char* name, WFlags fl)
        : KBloggerEditorBlank(parent,name,fl)
{
	ContentTextEditor->setCheckSpellingEnabled (true); // enable spell checking

	kdDebug() << "interfaceName() " << backend->interfaceName() << endl;	
	if( backend->interfaceName()!= "Blogger API 1.0") { // Only Blogger API doesn't support a title and categories
		TitleLineEdit->setReadOnly( false ); 
		CategoryComboBox->setEditable( true );
	}
	this->show();

}

KBloggerEditor::~KBloggerEditor()
{}

/*$SPECIALIZATION$*/
void KBloggerEditor::sendSlot()
{
	if( ContentTextEditor->text().isEmpty() )
		if( KMessageBox::questionYesNo( 0, 
		i18n("Are you sure you want to send without content?")  )!=0x00000100 ) // this is no good... the hex code for KDialog::ButtonCode Yes 
	return;
	sendSignal( TitleLineEdit->text(), ContentTextEditor->text(),  CategoryComboBox->currentText(), PublishCheckbox->isChecked() );
}

#include "kbloggereditor.moc"
