/***************************************************************************
 *   Copyright (C) 2005 by Christian Weilbach   *
 *   christian_weilbach@web.de   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#ifndef KBLOGGERMENU_H
#define KBLOGGERMENU_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qstring.h>
#include <qpoint.h>
#include <kpopupmenu.h>

#include "kblogger.h"

class KBlogger;

class KBloggerMenu : public KPopupMenu
{
	Q_OBJECT

	public:
		KBloggerMenu( KBlog::APIBlog*, KBlogger*, const char * = 0);
 		void setFullMenu(bool full) { m_fullMenu = full; }
		void setPosition( QPoint p ){ m_pos = p; }

	public slots:
		void populateMenu();

	private slots:
// 		void slotToggleOfflineMode();
// 		void slotCheckNews(int idx);
// 		void slotOpenArticle(int idx);
		void addPostingSlot( KBlog::BlogPosting& posting );
		void createMenuSlot();
		void deleteSlot( int postid );
		void bugSlot();
		void configurateSlot();
		void helpSlot();
		void aboutSlot();

	private:
		KBlog::APIBlog* m_backend;
		KBlogger *m_parent;
		QValueList<KBlog::BlogPosting> postings;
		QPoint m_pos;
		bool m_fullMenu;
};
#endif
