/***************************************************************************

   Copyright (C) 2007-2008 Antonio Aloisio <gnuton@gnuton.org>
   Copyright (C) 2008 Christian Weilbach <christian_weilbach@web.de>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the
   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
 ***************************************************************************/

#include "backend/waitdialog.h"

#include <KDebug>
#include <KDialog>

#include "waitwidget.h"

namespace KBlogger
{

WaitDialog::WaitDialog( int jobsQueued, QWidget* parent): KDialog(parent),
                   widget(0)
{
    kDebug();
    setCaption( i18n( "Running jobs." ) );
    setButtons( KDialog::Cancel );

    // create the widget for the progress bar and info text
    widget = new WaitWidget( this );
    widget->setMaxJobs( jobsQueued );
    setMainWidget( widget );   
}

WaitDialog::~WaitDialog()
{
    kDebug();
    delete widget;
}

void WaitDialog::setText( const QString& text )
{
    kDebug();
    widget->setText( text );
}

void WaitDialog::jobDone()
{
    kDebug();
    kDebug() << "Widget Pointer: " << widget;
    widget->jobDone();
}

}//namespace

#include "waitdialog.moc"

