/***************************************************************************
 *   Copyright (C) 2005 by Roberto Virga                                   *
 *   rvirga@users.sf.net                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <qimage.h>

#include <predictordata.h>

#include "kbspredictorpreferences.h"

KBSPredictorPreferences::KBSPredictorPreferences() : KConfigSkeleton()
{
  setCurrentGroup("ProteinPredictorAtHome - Molecule Log");
  
  int default_picture_format = QImageIO::outputFormats().find("PNG");
  if(default_picture_format < 0) default_picture_format = 0;
  
  for(unsigned i = MFOLD; i <= CHARMM; ++i)
  {
    addItemInt(QString("picture_filter_%1").arg(i), picture_filter[i], 0);
    addItemInt(QString("picture_format_%1").arg(i), picture_format[i], default_picture_format);
    addItemInt(QString("model_filter_%1").arg(i), model_filter[i], 0);
    addItemInt(QString("model_format_%1").arg(i), model_format[i], 0);
    addItemString(QString("location_%1").arg(i), location[i]);
    addItemInt(QString("molecule_style_%1").arg(i), style[i], 0);
    addItemInt(QString("coloring_%1").arg(i), coloring[i], 0);
  }
}

KBSPredictorMoleculeLogPreferences KBSPredictorPreferences::moleculeLogPreferences(PredictorAppType type)
{
  KBSPredictorMoleculeLogPreferences out;
  
  out.picture.filter = picture_filter[type];
  out.picture.format = (picture_format[type] >= 0) ? QImageIO::outputFormats().at(picture_format[type])
                                                   : "PNG";
  
  out.model.filter = model_filter[type];
  out.model.format = (0 == model_format[type]) ? "WRL" : "X3D";
  
  out.url = KURL(location[type]);
  out.url.adjustPath(+1);
  
  out.style = KBSPredictorMoleculeView::Style(style[type]);
  out.coloring = KBSPredictorMoleculeView::Coloring(coloring[type]);
  
  return out;
}
