/***************************************************************************
 *   Copyright (C) 2005 by Roberto Virga                                   *
 *   rvirga@users.sf.net                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef KBSPREDICTORPROJECTMONITOR_H
#define KBSPREDICTORPROJECTMONITOR_H

#include <qdict.h>
#include <qstringlist.h>

#include <kbsprojectmonitor.h>

#include <predictordata.h>

class KBSPredictorProjectMonitor : public KBSProjectMonitor
{
  Q_OBJECT
  public:
    KBSPredictorProjectMonitor(const QString &project, KBSBOINCMonitor *parent, const char *name=0);
    
    virtual const PredictorResult *result(const QString &workunit);

    virtual void setState(const QString &workunit, const PredictorState &state);
    
    virtual KBSLogManager *logManager() const;
    
  protected:
    virtual bool parseable(const QString &openName) const;
    virtual bool parseFile(KBSFileInfo *file, const QString &fileName);
    
    virtual PredictorResult *mkResult(const QString &workunt);
  
  private:
    bool parseScale3B(const QStringList &lines, QValueList<PredictorScale3B> &scale3b);
    bool parseMonssterChain(const QStringList &lines, QValueList<PredictorMonssterAtom> &chain);
    bool parseMonssterRestraints(const QStringList &lines,
                                 QValueList<PredictorMonssterRestraint> &restraints);
    bool parseProteinNOE(const QStringList &lines, QValueList<PredictorProteinNOE> &noe);
    bool parseSeedStream(const QStringList &lines, unsigned &seed);
    
    void setAppType(PredictorAppType app_type, const QStringList &workunits);
    void setBurials(const PredictorBurials &burials, const QStringList &workunits);
    void setECovers24(const PredictorECovers24 &ecovers_24, const QStringList &workunits);
    void setProfile3(const PredictorProfile3 &profile3, const QStringList &workunits);
    void setQuasi3(const PredictorQuasi3 &quasi3, const QStringList &workunits);
    void setScale3B(const QValueList<PredictorScale3B> &scale3b, const QStringList &workunits);
    void setS1234(const PredictorS1234 &s1234, const QStringList &workunits);
    void setS1234H(const PredictorS1234 &s1234h, const QStringList &workunits);
    void setS1234E(const PredictorS1234 &s1234e, const QStringList &workunits);
    void setMonssterInitChain(const QValueList<PredictorMonssterAtom> &init_chain,
                              const QStringList &workunits);
    void setMonssterInput(const PredictorMonssterInput &input, const QStringList &workunits);
    void setMonssterSeq(const PredictorMonssterSeq &seq, const QStringList &workunits);
    void setMonssterRestraints(const QValueList<PredictorMonssterRestraint> &restraints,
                               const QStringList &workunits);
    void setMonssterFinalChain(const QValueList<PredictorMonssterAtom> &final_chain,
                               const QStringList &workunits);
    void setMonssterFinalPDB(const PredictorProteinPDB &final_pdb, const QStringList &workunits);
    void setMonssterFinalNOE(const QValueList<PredictorProteinNOE> &final_noe,
                             const QStringList &workunits);
    void setCharmmInp(const PredictorCharmmInp &inp, const QStringList &workunits);
    void setProteinPDB(const PredictorProteinPDB &pdb, const QStringList &workunits);
    void setProteinNOE(const QValueList<PredictorProteinNOE> &noe, const QStringList &workunits);
    void setSeedStream(unsigned seed, const QStringList &workunits);
    void setProteinFinalPDB(const PredictorProteinPDB &final_pdb, const QStringList &workunits);
    
    static unsigned countGroups(const QValueList<PredictorAtomPDB> &pdb);
  
  private slots:
    void removeWorkunits(const QStringList &workunits);
    void logResults(const QStringList &results);
    void updateFile(const QString &fileName);
  
  protected:
    QDict<PredictorResult> m_results;

  private:
    QStringList m_start;
};

#endif
