/***************************************************************************
                          audiocd.cpp  -  description
                             -------------------
    begin                : Sat May 19 2001
    copyright            : (C) 2001 by Pascal 'PeP' Panneels
    email                : pepouille@skynet.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "audiocd.h"

AudioCD::AudioCD( QString dev)
: QObject()
{
	Device = dev;
	TOCAvailable = false;
	nr_tracks = 0;
	DiscID = "";
	ulDiscID = 0;
	CDLength = 0;
}

AudioCD::~AudioCD()
{
}

/** set the cdrom device */
void AudioCD::setDevice( QString dev)
{
	Device = dev;
}

/** return the DiscID as a string*/
QString AudioCD::getDiscID()
{
	if ( !TOCAvailable )
		{
		readTOC();
		if ( TOCAvailable )
			{
			computeDiscID();
			return DiscID;
			}
		else
			return QString("Invalid");
		}
	else
		return DiscID;
}

bool AudioCD::readTOC()
{
	struct cdrom_tochdr tochdr;
	struct cdrom_tocentry tocentry;
	int i;

	emit statusText((char *)"Reading Toc...");

	TOCAvailable = false;
	nr_tracks = 0;
	cdromfd = open( Device.latin1(), O_RDONLY|O_NONBLOCK );
	if (cdromfd == -1)
		{
		emit statusText((char *)"Read Toc - Open device error");
		return(false);
		}
		
	if (ioctl(cdromfd,CDROMREADTOCHDR,&tochdr) == -1)
		{
		emit statusText((char *)"Read Toc - Read TOC Header error");
		close(cdromfd);
		return(false);
		}

	tocentry.cdte_format = CDROM_MSF;
	for (i=tochdr.cdth_trk0;i<=tochdr.cdth_trk1;i++)
		{
		tocentry.cdte_track = i;
		if (ioctl(cdromfd,CDROMREADTOCENTRY,&tocentry) == -1)
			{
			emit statusText((char *)"Read Toc - Read TOC Entry error");
			close(cdromfd);
			return(false);
			}
		TOC[nr_tracks++] = tocentry.cdte_addr.msf;
		TrackOffsets.push_back( (TOC[nr_tracks-1].minute*60+TOC[nr_tracks-1].second)*75+TOC[nr_tracks-1].frame );
		}
	tocentry.cdte_track = CDROM_LEADOUT;
	if (ioctl(cdromfd,CDROMREADTOCENTRY,&tocentry) == -1)
		{
		emit statusText((char *)"Read Toc - Read TOC Entry (Lead-out) error");
		close(cdromfd);
		return(false);
        }
	TOC[nr_tracks] = tocentry.cdte_addr.msf;
	// cd length in seconds
	CDLength = TOC[nr_tracks].minute*60 + TOC[nr_tracks].second;
	// close the cdrom device
	close(cdromfd);
	TOCAvailable=true;
	return(true);
}

/** compute the cddb disc id */
void AudioCD::computeDiscID()
{
	int i=0, t=0, n=0;
	char str[10];
	
	if ( !TOCAvailable )
		return;
		
	while ( i < nr_tracks )
		{
		n = n + cddb_sum( ( TOC[i].minute * 60 ) + TOC[i].second );
		i++;
		}
	t = (( TOC[nr_tracks].minute * 60 ) + TOC[nr_tracks].second ) - (( TOC[0].minute * 60)+ TOC[0].second );
	// get the discid in unsigned long
	ulDiscID = (( n % 0xff) << 24 | t << 8 | nr_tracks);
	// format the disc id to get a hexdecimal 8 digits string
	sprintf(str, "%08lx", ulDiscID );
	DiscID = QString(str);
	
	emit statusText((char *)"DiscID computed !");

}

/** described in cddb documentation */

int AudioCD::cddb_sum(int n)
{
	int ret=0;
	while (n>0)
		{
		ret = ret+(n%10);
		n = n/10;
		}
	return ret;
}

/** return the DiscID as an unsigned long */
unsigned long AudioCD::getDiscIDul()
{
	if ( !TOCAvailable )
		{
		readTOC();
		if ( TOCAvailable )
			{
			computeDiscID();
			return ulDiscID;
			}
		else
			return 0;
		}
	else
		return ulDiscID;
}
/** return the track's offsets vector of int */
VectorIntType & AudioCD::getTrackOffsets()
{
	return TrackOffsets;
}

/** return the length in seconds of the CD */
unsigned long int AudioCD::getTotalLength()
{
	return CDLength;
}

/** return the number of tracks */
unsigned int AudioCD::getNumberTracks()
{
	return nr_tracks;
}
