/***************************************************************************
                          kcoverbackground.cpp  -  description
                             -------------------
    begin                : Mon Apr 16 2001
    copyright            : (C) 2001 by Pascal 'PeP' Panneels
    email                : pepouille@skynet.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kcoverbackground.h"
#include <kpixmap.h>

KCoverBackground::KCoverBackground(QColor c1, QColor c2)
{
	UseFlatMode = true;
	Color1 = c1;
	Color2 = c2;
	Mode = KPixmapEffect::VerticalGradient;
}

void KCoverBackground::Clear()
{
	UseFlatMode = true;
	Color1 = Qt::white;
	Color2 = Qt::blue;
	Mode = KPixmapEffect::VerticalGradient;
}

/** paint the object */
void KCoverBackground::Paint( QPainter *paint, QPoint orig, int W, int H )
{
	if ( UseFlatMode )
		{
		// save current pen
		QPen saved_pen = paint->pen();
		// draw a filled rectangle
		paint->setPen( Qt::NoPen );
		paint->fillRect( orig.x(), orig.y(), W, H, Color1 );
		// restore brush and pen
		paint->setPen(saved_pen);
		}
	else
		{
		KPixmap pix;
		pix.resize( W, H );
		// create the gradient
		KPixmapEffect::gradient( pix, Color1, Color2, Mode );
		// map the pixmap into the QPainter
		paint->drawPixmap( orig, pix );
		}
}

/** set the background attributes  */
void KCoverBackground::SetModeAttributes(QColor c1, QColor c2, int type,  bool useflatmode)
{
	UseFlatMode = useflatmode;
	Color1 = c1;
	Color2 = c2;
	Mode = KPixmapEffect::GradientType( type );
}

void KCoverBackground::Save(QFile &file)
{
	char tmp[10];
	int r1, g1, b1, r2, g2, b2;	
	
	tmp[0] = TAG_BACKGROUND;
	file.writeBlock( tmp, 1 );
	file.writeBlock( (char *)&UseFlatMode, sizeof(UseFlatMode) );
	file.writeBlock( (char *)&Mode, sizeof(Mode) );

	Color1.rgb( &r1, &g1, &b1 );
	Color2.rgb( &r2, &g2, &b2 );
	
	sprintf(tmp,"%c%c%c%c%c%c",r1, g1, b1, r2, g2, b2);
	file.writeBlock( tmp, 6 );	
	
}

void KCoverBackground::Load(QFile &file, int )
{
	int err;
	char tmp[10];
	
	err = file.readBlock( tmp, 1 );
	if ( tmp[0]!= TAG_BACKGROUND )
		return; // error
	err = file.readBlock( (char *)&UseFlatMode, sizeof(UseFlatMode) );
	err = file.readBlock( (char *)&Mode, sizeof(Mode) );
	err = file.readBlock( tmp, 6 );
   	
   	Color1 = QColor( (unsigned char)tmp[0], (unsigned char)tmp[1], (unsigned char)tmp[2] );
	Color2 = QColor( (unsigned char)tmp[3], (unsigned char)tmp[4], (unsigned char)tmp[5] );

}

bool KCoverBackground::ToBeSaved()
{
	return (Color1!=Qt::white && UseFlatMode)||(!UseFlatMode) ;
}
