/***************************************************************************
                          kcoverbackground.h  -  description
                             -------------------
    begin                : Mon Apr 16 2001
    copyright            : (C) 2001 by Pascal 'PeP' Panneels
    email                : pepouille@skynet.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KCOVERBACKGROUND_H
#define KCOVERBACKGROUND_H

#include <qcolor.h>
#include <qpainter.h>
#include <qpoint.h>
#include <kpixmapeffect.h>
#include <qfile.h>
#include <id.h>

/**draw a special page background
  *@author Pascal 'PeP' Panneels
  */

class KCoverBackground
{
public:
	// constructor + destructor
	KCoverBackground(QColor c1=Qt::white, QColor c2=Qt::blue);
	
  	/** paint the object */
  	virtual void Paint(QPainter *paint, QPoint orig, int W, int H);		// W and H and the width and the height of the background rectangle to be draw
	void SetModeAttributes(QColor c1, QColor c2, int type,  bool useflatmode=true);
	virtual void Save(QFile &file);
	virtual void Load(QFile &file, int version);
	virtual void Clear();		// reset to default values
	bool ToBeSaved();		// return true if the back have to be saved because it is different from white flat mode !
			
public :
	QColor Color1;
	QColor Color2;
	KPixmapEffect::GradientType Mode;
	bool UseFlatMode;
};

#endif
