/***************************************************************************
                          kcovermultistring.h  -  description
                             -------------------
    begin                : Thu Jun 29 2000
    copyright            : (C) 2000 by Pascal 'PeP' Panneels
    email                : pepouille@skynet.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KCOVERMULTISTRING_H
#define KCOVERMULTISTRING_H

#include <kcoverobject.h>
#include <vector>
#include <string>
#include <kcoverfont.h>
#include <qfile.h>
#include <qstring.h>

/**mutli line text object
  *@author Pascal 'PeP' Panneels
  */

class KCoverMultiString : public KCoverObject
{
public:
	KCoverMultiString();
	KCoverMultiString( std::vector<QString> &text, int x, int y, int order );
	KCoverMultiString(const KCoverMultiString &p);
	~KCoverMultiString();
	
  	virtual int GetClassType() {return TYPE_CLASS_MULTI_STRING;} ;
  	/** operator == for the comparison function */
  	int operator == (const KCoverMultiString &p) const;
  	/** return true if clicked is on a text */
  	virtual bool IsPointInObject(QPoint &pos);
  	virtual int Width();
  	virtual int Height();
  	virtual void Paint( QPainter *, QPoint);
  	virtual int RealX();
  	virtual int RealY();
	void ComputeLongestString();
	/** load an object */
  	virtual void Load(QFile &file, int version);
 	 /** save an object */
  	virtual void Save(QFile &file);
	virtual const int GetTopAlignDelta();
	virtual const int GetBottomAlignDelta();
	virtual const int GetMiddleAlignDelta();
			
public :
	std::vector<QString> Text;
	KCoverFont * Font;
	QColor * backcolor;
	QColor * textcolor;
	bool transparentbackground;
	char alignoption;
	unsigned int longest_string_index;
	int longest_width;
	bool info_valid;
	unsigned int Pixel_Separator;
};

#endif
