/***************************************************************************
                          kcoverobject.h  -  description
                             -------------------
    begin                : Mon Apr 3 2000
    copyright            : (C) 2000 by Pascal 'PeP' Panneels
    email                : pepouille@skynet.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KCOVEROBJECT_H
#define KCOVEROBJECT_H

#include <qpoint.h>
#include <qfile.h>
#include <id.h>
#include <klocale.h>
#include <align.h>

/**Base object for anything that could be drawn on the page layout; some classes should 
inherit from this (KCoverImage and KCoverString)

This is a Abstract class; you cannot instantiate object of this class; you have to overload
the function GetClassType, which should return 'TYPE_CLASS_xxx'

  *@author Pascal 'PeP' Panneels
  */

class KCoverPage;

class KCoverObject
{
public: 
  KCoverObject(int x=0, int y=0, int order=0, float angle=0.0 )
		{ X=x; Y=y; Order=order; IsMovable=true; Angle = angle; }
  virtual ~KCoverObject() {}
  /** copy constructor */
  KCoverObject( const KCoverObject &p )
  		{ X=p.X; Y=p.Y; Order=p.Order; IsMovable=p.IsMovable; Angle = p.Angle; }
  /** return the class type */
  virtual int GetClassType()=0;
  /** return true is a point is in a object or not */
  virtual bool IsPointInObject(QPoint &pos)=0;
  /**  return the widht of the gfx object */
  virtual int Width()=0;
  /**  return the height of the gfx object */
  virtual int Height()=0;
  /** save an object */
  virtual void Save(QFile &file);
  /** load an object */
  virtual void Load(QFile &file, int version);
  /** used for sorting on "Order" field */
  bool operator < (KCoverObject &p);
  /** draw the object */
  virtual void Paint( QPainter *, QPoint)=0;
  /** align an object on a page */
  virtual void Align( KCoverPage & page, const int halign, const int valign  );
  /** give a value to suibstract or add it pixels for alignement problems related to some objects like texts (for top) */
  virtual const int GetTopAlignDelta();
  /** give a value to suibstract or add it pixels for alignement problems related to some objects like texts (for bottom) */
  virtual const int GetBottomAlignDelta();
  /** give a value to suibstract or add it pixels for alignement problems related to some objects like texts (for centering) */
  virtual const int GetMiddleAlignDelta();

	
public :
	// relative position to 0,0 = upper left corner
	int X, Y;
	// relative order to the other object (0=most behind=first to be drawn)
	int Order;
	// flag to specify if an object can be moved or not; used when you draw a tiled pixmap
	bool IsMovable;
	// rotation angle for the drawing
	float Angle;
};

#endif
