/***************************************************************************
                          kdirtree.cpp  -  description
                             -------------------
    begin                : Sun Apr 30 2000
    copyright            : (C) 2000 by Pascal 'PeP' Panneels
    email                : pepouille@skynet.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kdirtree.h"
#include <dirent.h>
#include <string>
#include <vector>
#include <algorithm>
#include <error.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/stat.h>
#include <time.h>
#include <id.h>
#include <kapp.h>
#include <qcursor.h>

KDirTree::KDirTree( QWidget * parent, const char * basedir )
{
	BaseDir = QString( basedir );
	NumberOfFiles = 0;
	NumberOfDirectories = 0;
	Parent = parent;
	Cancelled = false;
}

/*KDirTree::~KDirTree()
{
}*/

void KDirTree::SetBaseDir( const char * basedir )
{
	BaseDir = QString( basedir );
}

void KDirTree::Traverse()
{
	DIR * DirFD;
	// try to open the directory
	if ( (DirFD = opendir( BaseDir.latin1())) == NULL )	// open the root CD directory
		{
		perror("OpenDir:");
		return;
		}
	// ok, we gonna read its content
	traverse( DirFD, BaseDir );
	closedir(DirFD);
	DirTree.sort();
}


void KDirTree::traverse( DIR * entrydir, QString dirname )
{
	struct dirent *dp;
	DIR * newdir;
	struct stat filestatus;
	
	if ( (entrydir!=NULL && !Cancelled ) )
		while (	(dp=readdir(entrydir))!=NULL  )
			{
			if ( !IsDir(dirname+"/"+QString(dp->d_name)) && (strcmp(dp->d_name,".")&&strcmp(dp->d_name,"..") ) )
				{
				DirTree.push_back(dirname+"/"+QString(dp->d_name));
				NumberOfFiles++;
				}
			else
				{
				QString newname = dirname+"/"+QString(dp->d_name);
				stat( newname.latin1(), &filestatus );
				if ( S_ISDIR(filestatus.st_mode) && strcmp(dp->d_name,".") && strcmp(dp->d_name,"..") && !S_ISLNK(filestatus.st_mode) )
					{
					NumberOfDirectories++;
					newdir = opendir( newname.latin1() );
					traverse(newdir, newname );
					closedir(newdir);
					}
				}
			}
}

int KDirTree::IsDir(QString entry)
{
	struct stat filestatus;
	stat(entry.latin1(), &filestatus);
	return S_ISDIR(filestatus.st_mode)|S_ISLNK(filestatus.st_mode);
}

int KDirTree::GetNumberOfTreeEntries()
{
	return ResultTree.size();
}

void KDirTree::BuildResultTree( int level )
{
	LevelToAnalyze = level;
	// erase the previous content
	ClearResultTree();
	// traverse the DirTree list
	for ( std::list<QString>::iterator DirTreeEntry = DirTree.begin(); DirTreeEntry!=DirTree.end(); DirTreeEntry++ )
		AddEntryToResult(*DirTreeEntry);
}


TreeNode KDirTree::GetResultTreeEntry( int i )
{
	return ResultTree[i];
}

void KDirTree::ClearResultTree()
{
	ResultTree.erase(ResultTree.begin(), ResultTree.end());
}

void KDirTree::AddEntryToResult(QString entry)
{
	ParseString(entry);
	unsigned int niveau;
	for (niveau=0; niveau<ParsedString.size()-1; niveau++)
		{
		if ( !AlreadyStored( ParsedString[niveau], niveau+1 ) )
			ResultTree.push_back( TreeNode( ParsedString[niveau], niveau+1, TYPE_DIR ) );
		if ( (int)niveau >= LevelToAnalyze )
			return;
		}
	if ( !AlreadyStored( ParsedString[niveau], niveau+1 ) )
		ResultTree.push_back( TreeNode( ParsedString[niveau], niveau+1, TYPE_FILE ) );
}

bool KDirTree::AlreadyStored( QString str, int level )
{
	for (int j=ResultTree.size()-1; j>=0; j-- )
		if ( (ResultTree[j].Level==level) && (ResultTree[j].FileName == str) )
			return true;
	return false;
}

void KDirTree::ParseString(QString entry)
{
	ParsedString.erase( ParsedString.begin(), ParsedString.end() );
	bool cont = true;
	QString toparse = entry.mid( BaseDir.length()+1, entry.length() );

	while ( cont )
		{
		int pos = toparse.find('/');
		if (pos>=0 && pos<(int)toparse.length())
			{
			ParsedString.push_back( toparse.left(pos));
			toparse = toparse.mid( pos+1, toparse.length() );
			}
		else
			{
			ParsedString.push_back(toparse);
			cont = false;
			}
		}
}

void KDirTree::Debug()
{
	for ( unsigned int i=0; i<ResultTree.size(); i++ )
		printf("%d : %s (%s)\n", ResultTree[i].Level, ResultTree[i].FileName.latin1(), ResultTree[i].Type==TYPE_DIR?"DIR":"FILE");
}

// save the tree
void KDirTree::Save(QFile &file)
{
	char tmp[25];
	
	tmp[0] = TAG_DIRTREE;
	int taille = DirTree.size();
	
	file.writeBlock( tmp, 1 );
	// write the number of strings
	file.writeBlock( (char *)&taille, sizeof(int) );
	// write the strings in the tree itself
	for ( std::list<QString>::iterator DirTreeEntry = DirTree.begin(); DirTreeEntry!=DirTree.end(); DirTreeEntry++ )
		{
		taille = (*DirTreeEntry).length();
		file.writeBlock((char *)&taille, sizeof(int));
		file.writeBlock( (*DirTreeEntry).latin1(), taille );
		}
}

// load a tree
void KDirTree::Load(QFile &file, int )
{
	char tmp[1024];
	int nombre, taille;
	
	file.readBlock( tmp, 1 );
	if ( tmp[0]!=TAG_DIRTREE )
		return;
	// read the number of strings
	file.readBlock( (char *)&nombre, sizeof(int) );
	// write the strings in the tree itself
	for ( int i=0; i<nombre; i++ )
		{
		file.readBlock((char *)&taille, sizeof(int));
		file.readBlock( tmp, taille );
		tmp[taille] = 0;
		DirTree.push_back(QString(tmp));
		}

}
