/***************************************************************************
                          kdirtree.h  -  description
                             -------------------
    begin                : Sun Apr 30 2000
    copyright            : (C) 2000 by Pascal 'PeP' Panneels
    email                : pepouille@skynet.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KDIRTREE_H
#define KDIRTREE_H

#include <dirent.h>
#include <string>
#include <list>
#include <vector>
#include <qfile.h>
#include <qwidget.h>
#include <qstring.h>

#define TYPE_DIR		1
#define TYPE_FILE		2

class TreeNode
{
public :
	TreeNode( QString a, int b, char c) { FileName = a; Level = b; Type = c; };
	TreeNode(const TreeNode &p) {  FileName = p.FileName; Level = p.Level; Type = p.Type;  };
	
public :
	QString FileName;		// entry name
	int Level;				// depth level
	char Type;				// TYPE_DIR or TYPE_FILE
};

/**implement directory traversing, access to directory structures ...
  *@author Pascal 'PeP' Panneels
  */

class KDirTree
{
public: 
	KDirTree(QWidget * parent, const char * basedir);
	//~KDirTree();
	// traverse the directory tree and store filenames
	void Traverse();
	// clear the list containing the directory tree
	void Clear() { DirTree.erase( DirTree.begin(), DirTree.end() ); }
	// set a new base directory
	void SetBaseDir( const char * basedir );
    // build the result tree according to the level in argument
    void BuildResultTree( int level );
    // get each entry of the result tree
    TreeNode GetResultTreeEntry( int i );
    // get the number of result tree entries
	int GetNumberOfTreeEntries();
    // save the tree
    void Save(QFile &file);
    // load a tree
    void Load(QFile &file, int version);

		
protected :
	// parse a directory tree on a disk
	void traverse( DIR * entrydir, QString dirname );
	// return >0 if a given entry is a directory
	int IsDir( QString entry);
	// clear the result tree
	void ClearResultTree();
	// check and add an entry to the result tree
	void AddEntryToResult( QString entry);
	// split a full path string into all the different pieces (dir + filename)
	void ParseString( QString entry);
	// look if a string is not already stored for a certain level
	bool AlreadyStored( QString str, int level )	;
	
	void Debug();
	
private :
	QString BaseDir;
	std::list<QString> DirTree;
	int NumberOfFiles;
	int NumberOfDirectories;
	std::vector<TreeNode> ResultTree;
	std::vector<QString> ParsedString;
	int LevelToAnalyze;
	QWidget * Parent;
	bool Cancelled;
};

#endif
