/***************************************************************************
                          psocket.cpp  -  description
                             -------------------
    begin                : Thu May 17 2001
    copyright            : (C) 2001 by Pascal 'PeP' Panneels
    email                : pepouille@skynet.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "psocket.h"

PSocket::PSocket()
{
	Host = QString("");
	Port = 0;
	State = StateType(NOT_CONNECTED);
}

PSocket::~PSocket()
{
	disconnect();
}

/** connect to a host / port */
int PSocket::connectToHost(const QString host, const unsigned short int port)
{
	// store the passed argument
	Host = QString(host);
	Port = port;
	
	// get the host address by its name
	if ( (he=gethostbyname(Host.latin1()))==NULL )
		{
		return State = StateType( ERROR_HOSTBYNAME );
		}
	
	// create a socket to connected to the host
	if ( (sockfd=socket(AF_INET, SOCK_STREAM, 0))==-1 )
		{
		return State = StateType( ERROR_SOCKET );
		}
		
	// init the structure used to define the connexion type
    server_addr.sin_family = AF_INET;      					// host byte order
    server_addr.sin_port = htons(port);    					// short, network byte order
    server_addr.sin_addr = *((struct in_addr *)he->h_addr);
    bzero(&(server_addr.sin_zero), 8);     					// zero the rest of the struct

	// connect to the server
    if (connect(sockfd, (struct sockaddr *)&server_addr, sizeof(struct sockaddr)) == -1)
    	{
		return State = StateType( ERROR_CONNECT );    	
    	}
    	
	sk = fdopen( sockfd, "r+" );	// open for read/write
	
	return State = StateType( CONNECTED );
}

/** disconnect (close) a connexion */
int PSocket::disconnect()
{
	close( sockfd );
	return State = StateType( NOT_CONNECTED );
}

/** read a block of data of maximum maxlen chars */
int PSocket::readBlock(char * buffer, int maxlen)
{
    if ( State!=StateType(CONNECTED))
    	return -1;
    	
/*    int i=0, r;
    char c;

    while( (r=recv(sockfd, &c, 1, 0)) != 0 )
    {
    	// we suppose we have answers "text line oriented"
        if (c == '\r' || c == '\n')
            break;
        if ( i > maxlen-1 )
            break;
        buffer[i] = c;
        i++;
    }
    //buffer[i] = '\n';                // add newline
    buffer[i] = 0;                 // terminate string
    recv(sockfd, &c, 1, 0);
*/
	fgets( buffer, maxlen, sk );
    return 1;
}

/** write a block of data of maximum len bytes */
int PSocket::writeBlock(char * buffer, int len)
{
    if ( State!=StateType(CONNECTED))
    	return -1;
	
//	int r = send(sockfd, buffer, len, MSG_NOSIGNAL );
	
	fprintf(sk, "%s\n", buffer);
	fflush(sk);
		
	return 1;
}

