/***************************************************************************
                          qscrollframe.h  -  description
                             -------------------
    begin                : Fri Jul 21 2000
    copyright            : (C) 2000 by Pascal 'PeP' Panneels
    email                : pepouille@skynet.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef QSCROLLFRAME_H
#define QSCROLLFRAME_H

#include <qframe.h>
#include <qpixmap.h>
#include <qpainter.h>
#include <qevent.h>
#include <qtimer.h>
#include <qcolor.h>
#include <qstring.h>
#include <qstrlist.h>

/**Widget that make a few lines of text scrolls from bottom to top
  *@author Pascal 'PeP' Panneels
  */

class QScrollFrame : public QFrame
{
Q_OBJECT

public: 
	QScrollFrame(QWidget * parent=0, const char * name=0, WFlags f=0, bool allowLines=TRUE);
	//~QScrollFrame();
  	/** specify the interval in milliseconds */
  	void setInterval(int msecs);
  	void setScrollText( char ** txt, int );
  	void start();
  	void stop();
  	void setBackgroundColor(QColor c) { Background = c; }
	void setDefaultFont(QFont f) { defaultFont = f; }
	void setDefaultColor(QColor c) { defaultColor = c; }
	  	
protected: // Protected methods
  	/** resize event */
  	virtual void resizeEvent ( QResizeEvent * );
  	/** draw content of the frame */
  	virtual void drawContents( QPainter * ) ;
  	/** paint event */
  	void paintEvent( QPaintEvent * e );

protected slots :
	/** time elapsed catch function */
	void ElapsedTime();

protected :	// protected attributes
  /** interval in msecs for the timer */
  int Interval;
  /** for the double buffering */
  QPixmap buffer;
  QPixmap tempbuf;
  QPixmap txtbuf;
  QPainter *txtpaint;
  /** current pos X and Y for the text */
  int PosX, PosY;
  /** timer */
  QTimer Clock;
  /** is scrolling running or not */
  bool Scrolling;
  /** background color */
  QColor Background;
  /** current line of text to draw */
  int Line;
  int MaxLines;
  bool NewLine;
  int Remains;
  /** default font */
  QFont defaultFont;
  /** default text color */
  QColor defaultColor;
  /** list of string to be displayed */
  char ** Text;
};

#endif
