/***************************************************************************
                          cddbinexactmatchdlg.cpp  -  description
                             -------------------
    begin                : Sun Jun 3 2001
    copyright            : (C) 2001 by Pascal 'PeP' Panneels
    email                : pepouille@skynet.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "cddbinexactmatchdlg.h"

CDDBInexactMatchDlg::CDDBInexactMatchDlg(MatchedEntries &match, unsigned int *choosenentry, QWidget *parent, const char *name)
: QDialog(parent,name,true)
{
	initDialog();
	
	ChoosenEntry = choosenentry;
	//init title in the listview
	InexactList->addColumn("Category", 63 );
	InexactList->addColumn("CD Entry",350 );
	InexactList->addColumn("DiscID",60 );
	InexactList->setAllColumnsShowFocus( true );
	
	// fill the listview
	for ( unsigned int i=0; i<match.size(); i++ )
		InexactList->insertItem( new QListViewItem( InexactList, QString(match[i].Category), QString(match[i].DiscTitle), QString(match[i].DiscID) ) );

//	InexactList->insertItem( new QListViewItem( InexactList, QString("hardrock"), QString("Iron Maiden - Brave New World"), QString("a1234cde") ) );
//	InexactList->insertItem( new QListViewItem( InexactList, QString("rock"), QString("Iron Maiden - New World"), QString("f7894cde") ) );	
	
	OkButton->setEnabled( false );
	
	// handle signals
	QObject::connect(OkButton, SIGNAL(clicked()), this, SLOT(CmOk()));
	QObject::connect(CancelButton, SIGNAL(clicked()), this, SLOT(reject()));
	QObject::connect(InexactList, SIGNAL(selectionChanged(QListViewItem *)), this, SLOT(CeOk()));
		
}

/** cmok  */
void CDDBInexactMatchDlg::CmOk()
{
	//*ChoosenEntry = InexactList->itemPos( InexactList->selectedItem() );	// -1 because we have the title line
	*ChoosenEntry = 0;
	accept();
}

/** ceok : enable the ok button */
void CDDBInexactMatchDlg::CeOk()
{
	OkButton->setEnabled(true);
}

