/***************************************************************************
                          kcoverbody.cpp  -  description
                             -------------------
    begin                : Wed Jul 19 2000
    copyright            : (C) 2000 by Pascal 'PeP' Panneels
    email                : pepouille@skynet.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kcoverbody.h"
#include <string>
#include <qfontmetrics.h>
#include <id.h>

KCoverBody::KCoverBody(QWidget * parent, char * dir, int level, int column, int startpage, bool line, bool treeline, bool disppageno )
{
	DisplayPageNumber 	= disppageno;
	BodyTreeLine 		= treeline;
	BodyLined			= line;
	BodyPage			= startpage;
	Columns				= column;
	Levels				= level;
	strcpy(SourceCD, dir);
	myDirTree 			= new KDirTree(parent, SourceCD);
	BodyFont			= new KCoverFont((char *)("Helvetica"));
	BodyFont->Font->setPointSize(10);
}

KCoverBody::~KCoverBody()
{
	delete myDirTree;
	delete BodyFont;
}

void KCoverBody::MarkPagesToPrint( KCoverPage &BackPage, std::vector<KCoverPage> &FrontPages )
{
	// check the parameters
	if ( ( Columns==0 ) )
		return;
		
	if ( BodyPage==0 )
		BackPage.PageToPrint = true;
	else
		{
		// compute the number of pages of which the body lies
	   	QFontMetrics FontMetric(*BodyFont->Font);
   		int LineHeight = FontMetric.height()+3;	// must be adapted according the size of the font
		int A = ( myDirTree->GetNumberOfTreeEntries() * LineHeight ) / Columns;
		int NumberPages = ( A / FRONT_V ) + ( A % FRONT_V ? 1 : 0 );
		for ( int i=BodyPage; i<BodyPage+NumberPages; i++ )
			FrontPages[i].PageToPrint = true;
		}
}

void KCoverBody::Paint( QPainter *paint, int page, int TopX, int TopY, KCoverPage &ReferencedPage )
{
    // draw the body content
   	QFontMetrics FontMetric(*BodyFont->Font);
   	int LineHeight = FontMetric.height()+3;	// must be adapted according the size of the font
    if ( Columns && ( (page+1>=BodyPage && BodyPage )||( BodyPage==0 && page==-1) ) )
    	{
    	paint->setPen( Qt::black );
    	int ColumnWidth = (page!=-1?FRONT_H:BACK_HI) / Columns - 8 ;  	// columns width in pixels
    	// draw the vertical colums lines
    	for (int i=0;i<Columns-1;i++)
    		paint->drawLine( TopX + (i+1)*(ColumnWidth+8)+(page!=-1?0:BACK_HS), TopY+4, (page!=-1?0:BACK_HS)+TopX + (i+1)*(ColumnWidth+8), TopY + (page!=-1?FRONT_V:BACK_V) -4);
    	// draw the text content of the columns
    	int MaxLines = ( page!=-1?FRONT_V:BACK_V ) / LineHeight;
    	int MaxItemsPerPage = Columns * MaxLines ;
    	int Item = page!=-1?(( 1+page - BodyPage ) * MaxItemsPerPage):0;
    	paint->setFont(*BodyFont->Font);
    	for (int Col=0; ( Col < Columns ) && ( Item < myDirTree->GetNumberOfTreeEntries() ); Col++ )
    		{
    		ReferencedPage.PageToPrint = true;
    		for (int Line=0; ( Line<MaxLines ) && ( Item < myDirTree->GetNumberOfTreeEntries() ); Line++)
    			{
    			if (myDirTree->GetResultTreeEntry(Item).Type == TYPE_DIR)
    				BodyFont->Font->setBold(true);
    			else
    				BodyFont->Font->setBold(false);    			
    			// draw a horizontal line if needed
    			if ( BodyLined )
    				paint->drawLine( (page!=-1?0:BACK_HS) + 4 + TopX + (ColumnWidth+8)*Col, TopY+((Line+1)*LineHeight), (page!=-1?0:BACK_HS) + 4 + TopX + (ColumnWidth+8)*Col+ColumnWidth, TopY+((Line+1)*LineHeight) );
    			// draw the tree structure line if needed
    			int currentlevel = myDirTree->GetResultTreeEntry(Item).Level;
    			if ( BodyTreeLine && currentlevel > 1 )
    				{
    				int Left_X 		= 6 + TopX + (ColumnWidth+8) * Col + (page!=-1?0:BACK_HS);
    				int Top_Y 		= TopY+((Line)*LineHeight) - 3 ;
    				if ( Top_Y<TopY ) Top_Y = Top_Y + 6;
    				int Bottom_Y	= Top_Y + LineHeight;
    				int n;
    				for (n=0; n < myDirTree->GetResultTreeEntry(Item).Level-2; n++ )
    					{
    					paint->drawLine( Left_X + n*7, Top_Y, Left_X + n*7, Bottom_Y );
    					}
    				if ( n>=0 )
    					{
    					if ( Item<myDirTree->GetNumberOfTreeEntries() && Item<myDirTree->GetNumberOfTreeEntries()-1?(myDirTree->GetResultTreeEntry(Item+1).Level >= myDirTree->GetResultTreeEntry(Item).Level):false )
	    					paint->drawLine( Left_X + n*7, Top_Y, Left_X + n*7, Bottom_Y );
	    				else
	    					paint->drawLine( Left_X + n*7, Top_Y, Left_X + n*7, Top_Y + ((Bottom_Y - Top_Y+3)/2) );
    					paint->drawLine( Left_X + n*7, Top_Y + ((Bottom_Y - Top_Y + 3)/2), Left_X + n*7 + 2, Top_Y + ((Bottom_Y - Top_Y+3)/2) );
    					}
	  				}
    			
    			paint->setFont(*BodyFont->Font);
    			paint->drawText( (page!=-1?0:BACK_HS) + 4 + TopX + (ColumnWidth+8) * Col + ( myDirTree->GetResultTreeEntry(Item).Level-1 ) * 7,
    							 TopY + Line * LineHeight + 2,
    							 ColumnWidth - ( myDirTree->GetResultTreeEntry(Item).Level-1 ) * 7,
    							 LineHeight,
    							 Qt::AlignTop | Qt::SingleLine | Qt::ShowPrefix /*| WordBreak*/,
    							 myDirTree->GetResultTreeEntry(Item).FileName.latin1() );
    			Item++;
    			}
    		}
    	}
    // display page number
    if (DisplayPageNumber && page+1>=BodyPage && page!=-1 )
    	{
    	char tmp[10];
    	sprintf(tmp,"%d", page+1);
    	int size = BodyFont->Font->pointSize();
    	BodyFont->Font->setPointSize(10);
		BodyFont->Font->setBold(false);
		paint->setFont(*BodyFont->Font);
		paint->drawText( TopX + FRONT_H - 20,
						 TopY + FRONT_V - 20,
						 50,
						 LineHeight,
						 Qt::AlignTop | Qt::SingleLine | Qt::ShowPrefix /*| WordBreak*/,
						 tmp );
		BodyFont->Font->setPointSize(size);
    	}
}

/** save the body */
void KCoverBody::Save(QFile &file)
{
	char tmp[25];
	int n;
	
	// save the tag BODY
	tmp[0] = TAG_BODY;
	file.writeBlock( tmp, 1 );
	// save the tree
	myDirTree->Save(file);
	// save the font
	BodyFont->Save(file);
	// source Cd path
	n = strlen(SourceCD);
	file.writeBlock((char *)&n, sizeof(int)	);
	file.writeBlock( SourceCD, n );
	// colmumn, levels ...
	file.writeBlock( (char *)&Columns, sizeof(int) );
	file.writeBlock( (char *)&Levels, sizeof(int) );
	file.writeBlock( (char *)&BodyPage, sizeof(int) );
	sprintf(tmp, "%c%c%c", BodyLined, BodyTreeLine, DisplayPageNumber );
	file.writeBlock( tmp, 3 );
	
}

/** load the body */
void KCoverBody::Load(QFile &file, int version)
{
	char tmp[25];
	int n;
	
	// load the tag BODY
	file.readBlock( tmp, 1 );
	if ( tmp[0]!=TAG_BODY )
		return;
	// load the tree
	myDirTree->Load( file, version );
	// load the font
	BodyFont->Load( file, version );
	// source cd path
	file.readBlock( (char *)&n, sizeof(int)	);
	file.readBlock( SourceCD, n );
	SourceCD[n]=0;
	// columns, levels ...
	file.readBlock( (char *)&Columns, sizeof(int) );
	file.readBlock( (char *)&Levels, sizeof(int) );
	file.readBlock( (char *)&BodyPage, sizeof(int) );
	file.readBlock( tmp, 3 );
	BodyLined 			= tmp[0];
	BodyTreeLine 		= tmp[1];
	DisplayPageNumber 	= tmp[2];

}
/** construct the result tree according to the levels */
void KCoverBody::BuildResultTree()
{
	int levels = Levels - LEVEL_ALL - 1;
	if ( Levels==LEVEL_ALL ) levels=999999;
	myDirTree->BuildResultTree( levels );
}
