/***************************************************************************
                          kcpreferences.cpp  -  description
                             -------------------
    begin                : Sat Jan 27 2001
    copyright            : (C) 2001-2005 by Javier Campos Morales and the Kconfigure Team
    email                : kconfigure@rockerssoft.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include "kcpreferences.h"
#include "kcpreferences.moc"

#include <qlabel.h> 
#include <qvbox.h>
#include <qlayout.h>
#include <qtabwidget.h>
#include <qbuttongroup.h>
#include <qabstractlayout.h>
#include <qpixmap.h>

#include <kstddirs.h>
#include <kiconloader.h>
#include <kconfig.h>
#include <kglobalsettings.h>
#include <kfiledialog.h>
#include <kfile.h>

Kcpreferences::Kcpreferences(QWidget *parent, const char *name, bool modal) : KDialogBase(IconList,i18n("Preferences"),Help|Ok|Cancel,Ok, parent, name, modal, true)
{
	configRead();
	setPage_Font();
	setPage_CheckInstall();
	setPage_Misc();
	setConfigDialog();
}

Kcpreferences::~Kcpreferences(){
}

/** Set the font  Page of the preferences dialog */
void Kcpreferences::setPage_Font()
{
	QVBox *mainFrame = addVBoxPage( i18n("Fonts"), i18n("Select font to the log views"), DesktopIcon("fonts"));
	QTabWidget *mainTab = new QTabWidget( mainFrame, "tabDialog1" );

	QVBox *insideTab1 = new QVBox( this, "tab1" );
	insideTab1->setSpacing( 6 );
	insideTab1->setMargin( 11 );
	font_main = new KFontChooser(insideTab1);
	mainTab->addTab( insideTab1, "Main View" );

	QVBox *insideTab2 = new QVBox( this, "tab2" );
	insideTab2->setSpacing( 6 );
	insideTab2->setMargin( 11 );
	font_error = new KFontChooser(insideTab2);
	mainTab->addTab( insideTab2, "Error View" );
}

/** Set the checkinstall  Page of the preferences dialog */
void Kcpreferences::setPage_CheckInstall()
{
	QVBox *mainFrame = addVBoxPage( i18n("Check Install"), i18n("Check Install Settings"), DesktopIcon("button_ok"));
	
	QButtonGroup *ButtonGroup2 = new QButtonGroup( mainFrame, "ButtonGroup2" );
	ButtonGroup2->setTitle( i18n( "Enable Checkinstall" ) );
	ButtonGroup2->setColumnLayout(0, Qt::Vertical );
	ButtonGroup2->layout()->setSpacing( 0 );
	ButtonGroup2->layout()->setMargin( 0 );
	QVBoxLayout *ButtonGroup2Layout = new QVBoxLayout( ButtonGroup2->layout() );
	ButtonGroup2Layout->setAlignment( Qt::AlignTop );
	ButtonGroup2Layout->setSpacing( 6 );
	ButtonGroup2Layout->setMargin( 11 );
	
	checkinstall_yes = new QCheckBox( ButtonGroup2, "enablecheckinstall" );
	checkinstall_yes->setText( i18n( "Use Checkinstall (requires root access)." ) );
		connect( checkinstall_yes, SIGNAL( clicked() ), this, SLOT( slotCheckInstallCheck() ) );
	ButtonGroup2Layout->addWidget( checkinstall_yes );
	
	QLabel *kurlcheckinstall_label = new QLabel( ButtonGroup2, "Label1");
	kurlcheckinstall_label->setText( i18n( "Location of checkinstall executable:" ) );
	ButtonGroup2Layout->addWidget( kurlcheckinstall_label );
	
	kurlcheckinstall = new KURLRequester( ButtonGroup2, "url_checkinstall" );
	kurlcheckinstall->setURL( "/usr/sbin/checkinstall" );
		(kurlcheckinstall->fileDialog())->setMode(  (KFile::Mode)(KFile::Directory|KFile::LocalOnly) );
	ButtonGroup2Layout->addWidget( kurlcheckinstall );
	
	/** Package format to install as */
	QButtonGroup *ButtonGroup1 = new  QButtonGroup( mainFrame, "ButtonGroup1" );
	ButtonGroup1->setTitle( i18n( "Package Format" ) );
	ButtonGroup1->setColumnLayout(0, Qt::Vertical );
	ButtonGroup1->layout()->setSpacing( 0 );
	ButtonGroup1->layout()->setMargin( 0 );
	
	QVBoxLayout *ButtonGroup1Layout = new QVBoxLayout( ButtonGroup1->layout() );
	ButtonGroup1Layout->setAlignment( Qt::AlignTop );
	ButtonGroup1Layout->setSpacing( 6 );
	ButtonGroup1Layout->setMargin( 11 );
	
	RPMradio = new QRadioButton( ButtonGroup1, "RadioButton6" );
	RPMradio->setText( i18n( "Redhat, Mandrake, or Suse packages (RPM)." ) );
	RPMradio->setChecked(true);
	ButtonGroup1Layout->addWidget( RPMradio );
	
	DKPGradio = new QRadioButton( ButtonGroup1, "RadioButton7" );
	DKPGradio->setText( i18n( "Debain packages." ) );
	ButtonGroup1Layout->addWidget( DKPGradio );
	
	SLKradio = new QRadioButton( ButtonGroup1, "RadioButton8" );
	SLKradio->setText( i18n( "Slackware package" ) );
	ButtonGroup1Layout->addWidget( SLKradio );
	
	/** Check install options for more custom install */
	QButtonGroup *ButtonGroup3 = new  QButtonGroup( mainFrame, "ButtonGroup3" );
	ButtonGroup3->setTitle( i18n( "Advanced Options" ) );
	ButtonGroup3->setColumnLayout(0, Qt::Horizontal );
	ButtonGroup3->layout()->setSpacing( 0 );
	ButtonGroup3->layout()->setMargin( 0 );
	
	QGridLayout *ButtonGroup3Layout = new QGridLayout( ButtonGroup3->layout() );
	ButtonGroup3Layout->setAlignment( Qt::AlignTop );
	ButtonGroup3Layout->setSpacing( 6 );
	ButtonGroup3Layout->setMargin( 11 );
	
	backup_yes = new QCheckBox( ButtonGroup3, "backupfiles" );
	backup_yes->setText( i18n( "Backup Overwritten Files." ) );
	ButtonGroup3Layout->addWidget( backup_yes, 0, 0 );
	
	Elfstrip_yes = new QCheckBox( ButtonGroup3, "elfstripbinary" );
	Elfstrip_yes->setText( i18n( "Strip ELF Binaries." ) );
	ButtonGroup3Layout->addWidget( Elfstrip_yes, 0, 1 );
	
	textLabel1 = new QLabel( ButtonGroup3, "textLabel1" );
	textLabel1->setText( i18n( "Custom Options:" ) );
	ButtonGroup3Layout->addWidget( textLabel1, 1, 0 );
	
	customOptions = new QLineEdit( ButtonGroup3, "lineEdit1" );
	ButtonGroup3Layout->addMultiCellWidget( customOptions, 2, 2, 0, 1 );

}

/** Set the Misc options Page of the preferences dialog */
void Kcpreferences::setPage_Misc()
{
	QVBox *mainFrame = addVBoxPage( i18n("Miscellaneous"), i18n("Various settings"), DesktopIcon("misc"));

	QButtonGroup *ButtonGroup1 = new QButtonGroup( mainFrame, "ButtonGroup1" );
	ButtonGroup1->setTitle( i18n( "Compress Sources" ) );
	ButtonGroup1->setColumnLayout(0, Qt::Vertical );
	ButtonGroup1->layout()->setSpacing( 0 );
	ButtonGroup1->layout()->setMargin( 0 );
	QVBoxLayout *ButtonGroup1Layout = new QVBoxLayout( ButtonGroup1->layout() );
	ButtonGroup1Layout->setAlignment( Qt::AlignTop );
	ButtonGroup1Layout->setSpacing( 6 );
	ButtonGroup1Layout->setMargin( 11 );
	
	compress_dir = new QCheckBox( ButtonGroup1, "compress_dir" );
	compress_dir->setText( i18n( "Save sources in a personal directory" ) );
		connect( compress_dir, SIGNAL( clicked() ), this, SLOT( slotDirCompressCheck() ) );
	ButtonGroup1Layout->addWidget( compress_dir );
	
	kurlcompress = new KURLRequester( ButtonGroup1, "url_compress" );
	(kurlcompress->fileDialog())->setMode(  (KFile::Mode)(KFile::Directory|KFile::LocalOnly) );
	ButtonGroup1Layout->addWidget( kurlcompress );
		
	QButtonGroup *ButtonGroup2 = new QButtonGroup( mainFrame, "ButtonGroup2" );
	ButtonGroup2->setTitle( i18n( "Logs" ) );
	ButtonGroup2->setColumnLayout(0, Qt::Vertical );
	ButtonGroup2->layout()->setSpacing( 0 );
	ButtonGroup2->layout()->setMargin( 0 );
	QVBoxLayout *ButtonGroup2Layout = new QVBoxLayout( ButtonGroup2->layout() );
	ButtonGroup2Layout->setAlignment( Qt::AlignTop );
	ButtonGroup2Layout->setSpacing( 6 );
	ButtonGroup2Layout->setMargin( 11 );
	
	logs_start = new QCheckBox( ButtonGroup2, "logs_start" );
	logs_start->setText( i18n( "Start kconfigure with log enabled" ) );
	ButtonGroup2Layout->addWidget( logs_start );
	
	logs_sources = new QRadioButton( ButtonGroup2, "logs_sources" );
	logs_sources->setText( i18n( "Save logs in the directory sources" ) );
		connect( logs_sources, SIGNAL( clicked() ), this, SLOT( slotLogCheck() ) );
	ButtonGroup2Layout->addWidget( logs_sources );
	
	logs_personal = new QRadioButton( ButtonGroup2, "logs_personal" );
	logs_personal->setText( i18n( "Save logs in a personal directory" ) );
		connect( logs_personal, SIGNAL( clicked() ), this, SLOT( slotLogCheck() ) );
	ButtonGroup2Layout->addWidget( logs_personal );
	
	kurlrequest = new KURLRequester( ButtonGroup2, "openurl" );
	(kurlrequest->fileDialog())->setMode(  (KFile::Mode)(KFile::Directory|KFile::LocalOnly) );
	ButtonGroup2Layout->addWidget( kurlrequest );
		
	logs_html = new QCheckBox( ButtonGroup2, "logs_html" );
	logs_html->setText( i18n( "Logs in HTML format" ) );
	ButtonGroup2Layout->addWidget( logs_html );
}

/** Put the our config settings into our dialog */
void Kcpreferences::setConfigDialog()
{
	/** Fonts Dialog */
	font_main->setFont( Fonts_Default );
	font_error->setFont( Fonts_Error );
	/** Extract Options for Misc Dialog */
	compress_dir->setChecked( Is_Decompress );
	kurlcompress->setURL( Decompress_Dir );
	/** Log Options for Misc Dialog */
	logs_start->setChecked( Is_Logged );
	logs_sources->setChecked( Is_LogInSources );
	logs_personal->setChecked( Is_LogInHome );
	kurlrequest->setURL( Log_Dir );
	logs_html->setChecked( Is_LogHTML );
	/** CheckInstall Dialog */	
	checkinstall_yes->setChecked( Is_Checkinstall );
	kurlcheckinstall->setURL( CheckInstall_Command );
	RPMradio->setChecked( Is_RPM );
	DKPGradio->setChecked( Is_DKPG );
	SLKradio->setChecked( Is_SLK );
	backup_yes->setChecked( Is_BackFiles );
	Elfstrip_yes->setChecked( Is_ElfStrip );
	customOptions->setText( Comstom_Command );
	
	slotCheckInstallCheck();
	slotLogCheck();
	slotDirCompressCheck();

}

/** Read the settings */
void Kcpreferences::configRead()
{
	KConfig *config = KGlobal::config();

	config->setGroup("General");
	QFont defaultFont(KGlobalSettings::generalFont());
	Fonts_Default = config->readFontEntry( "Font log", &defaultFont );
	Fonts_Error = config->readFontEntry( "Font error", &defaultFont );

	config->setGroup("Compress");	
	Is_Decompress = config->readBoolEntry( "Compress in dir", false );
	Decompress_Dir = config->readEntry("Directory", "" );

	config->setGroup("Log");	
	Is_Logged = config->readBoolEntry( "Log start", true );
	Is_LogInSources = config->readBoolEntry( "Log in sources", true );
	Is_LogInHome = config->readBoolEntry( "Log in dir", false );
	Log_Dir = config->readEntry( "Directory", "" );
	Is_LogHTML = config->readBoolEntry( "Log in html", true );

	config->setGroup("Checkinstall");
	Is_Checkinstall = config->readBoolEntry( "Enable Checkinstall", false );
	CheckInstall_Command = config->readEntry( "Checkinstall Command", "/usr/sbin/checkinstall" );
	Is_RPM = config->readBoolEntry( "RPM Package", true );
	Is_DKPG = config->readBoolEntry( "Debian Package", false );
	Is_SLK = config->readBoolEntry( "Slackware Package", false );
	Is_BackFiles = config->readBoolEntry( "Backup Overwrite Files", true );
	Is_ElfStrip = config->readBoolEntry( "Strip Elf Binaries", true );
	Comstom_Command = config->readEntry( "Custom Options", "--pkgrelease=1.kcfg" );
	
}

/** Get our config settings from the Settings dialog */
void Kcpreferences::readConfigDialog()
{
	/** Fonts Dialog */
	Fonts_Default =  font_main->font();
	Fonts_Error = font_error->font();
	/** Extract Options from Misc Dialog */
	Is_Decompress = compress_dir->isChecked(); 
	Decompress_Dir = kurlcompress->url();
	/** Log Options from Misc Dialog */
	Is_Logged = logs_start->isChecked();
	Is_LogInSources = logs_sources->isChecked();
	Is_LogInHome = logs_personal->isChecked();
	Log_Dir = kurlrequest->url();
	Is_LogHTML = logs_html->isChecked();
	/** CheckInstall Dialog */
	Is_Checkinstall = checkinstall_yes->isChecked();
	CheckInstall_Command = kurlcheckinstall->url();
	Is_RPM = RPMradio->isChecked();
	Is_DKPG = DKPGradio->isChecked();
	Is_SLK = SLKradio->isChecked();
	Is_BackFiles = backup_yes->isChecked();
	Is_ElfStrip = Elfstrip_yes->isChecked();
	Comstom_Command = customOptions->text();
	/** Which Install List Menu */
	if( checkinstall_yes->isChecked() ) { useInstall = 1; } 
	else { useInstall = 0; }

}

/** Read the settings */
void Kcpreferences::configWrite()
{
	KConfig *config = KGlobal::config();

	config->setGroup("General");
	config->writeEntry( "Font log", Fonts_Default );
	config->writeEntry( "Font error", Fonts_Error );

	config->setGroup("Compress");	
	config->writeEntry( "Compress in dir", Is_Decompress );
	config->writeEntry( "Directory", Decompress_Dir );

	config->setGroup("Log");	
	config->writeEntry( "Log start", Is_Logged );
	config->writeEntry( "Log in sources", Is_LogInSources );
	config->writeEntry( "Log in dir", Is_LogInHome );
	config->writeEntry( "Directory", Log_Dir );
	config->writeEntry( "Log in html", Is_LogHTML );
	
	config->setGroup("Checkinstall");
	config->writeEntry( "Enable Checkinstall", Is_Checkinstall );
	config->writeEntry( "Checkinstall Command", CheckInstall_Command );
	config->writeEntry( "RPM Package", Is_RPM );
	config->writeEntry( "Debian Package", Is_DKPG );
	config->writeEntry( "Slackware Package", Is_SLK );
	config->writeEntry( "Backup Overwrite Files", Is_BackFiles );
	config->writeEntry( "Strip Elf Binaries", Is_ElfStrip );
	config->writeEntry( "Custom Options", Comstom_Command );
	
	config->setGroup("InstallOptions");
	config->writeEntry( "Use Install", useInstall );

	config->sync();
}

/** Ok button */
void Kcpreferences::slotOk()
{
	readConfigDialog();
	configWrite();
	this->accept();
}

/** enables and disables the log sources url file dialogs */
void Kcpreferences::slotLogCheck()
{
	if( logs_sources->isChecked() )
	{		if( kurlrequest->isEnabled() ) kurlrequest->setEnabled(false);		}
	else
	{		if( !kurlrequest->isEnabled() ) kurlrequest->setEnabled(true);		}
}

/** Enables and disables the compress file dialogs */
void Kcpreferences::slotDirCompressCheck()
{
	if( compress_dir->isChecked() )
	{		if( !kurlcompress->isEnabled() ) kurlcompress->setEnabled(true);		}
	else
	{		if( kurlcompress->isEnabled() ) kurlcompress->setEnabled(false);		}
}

/** Enables and disables the checkinstall file dialogs */
void Kcpreferences::slotCheckInstallCheck()
{
	if( checkinstall_yes->isChecked() ) {
		if( !RPMradio->isEnabled() ) RPMradio->setEnabled(true);
		if( !SLKradio->isEnabled() ) SLKradio->setEnabled(true);
		if( !DKPGradio->isEnabled() ) DKPGradio->setEnabled(true);
		if( !kurlcheckinstall->isEnabled() ) kurlcheckinstall->setEnabled(true);
		if( !backup_yes->isEnabled() ) backup_yes->setEnabled(true);
		if( !Elfstrip_yes->isEnabled() ) Elfstrip_yes->setEnabled(true);
		if( !textLabel1->isEnabled() ) textLabel1->setEnabled(true);
		if( !customOptions->isEnabled() ) customOptions->setEnabled(true);
		
	}
	else { 
		if( RPMradio->isEnabled() ) RPMradio->setEnabled(false);
		if( SLKradio->isEnabled() ) SLKradio->setEnabled(false);
		if( DKPGradio->isEnabled() ) DKPGradio->setEnabled(false);
		if( kurlcheckinstall->isEnabled() ) kurlcheckinstall->setEnabled(false);
		if( backup_yes->isEnabled() ) backup_yes->setEnabled(false);
		if( Elfstrip_yes->isEnabled() ) Elfstrip_yes->setEnabled(false);
		if( textLabel1->isEnabled() ) textLabel1->setEnabled(false);
		if( customOptions->isEnabled() ) customOptions->setEnabled(false);
	}
}
