/***************************************************************************
 *   Copyright (C) 2005 by Felipe Sateler                                  *
 *   fsateler@gmail.com                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA 02110-1301, USA.           *
 ***************************************************************************/

#include <qgroupbox.h>
#include <klistview.h>
#include <kpushbutton.h>
#include <klocale.h>
#include <kinputdialog.h>
#include <qvaluelist.h>

#include <iostream>

#include "autostartwidget.h"
#include "autostartlistviewitem.h"

AutostartWidget::AutostartWidget(QWidget* parent, const char* name, WFlags fl)
	: AutostartWidgetBase(parent,name,fl)
{
	groupBox->setTitle( i18n("User startup apps") );
	appListView->addColumn( i18n("Application") );
	appListView->addColumn( i18n("Command") );
	appListView->addColumn( i18n("Comment") );
}

AutostartWidget::~AutostartWidget()
{
}

/*$SPECIALIZATION$*/
void AutostartWidget::slotEdit()
{
	AutostartListViewItem* item = dynamic_cast<AutostartListViewItem*>( appListView->currentItem() );
	if( item == NULL )
		return;
	
	QString name = KInputDialog::getText( i18n("Application Name"),
										  i18n("Insert the new application's name:"), item->getName() );
	QString command = KInputDialog::getText( i18n("Application Command"),
											 i18n("Insert the new application's command:"), item->getCommand());
	QString comment = KInputDialog::getText( i18n("Application Comment"),
											 i18n("Insert a comment for the new application"), item->getComment() );
	item->setName(name);
	item->setCommand(command);
	item->setComment(comment);
	
	emit changed();
}

void AutostartWidget::slotRemove()
{
	appListView->removeItem( appListView->currentItem() );
	
	emit changed();
}

void AutostartWidget::slotAdd()
{
	QString name = KInputDialog::getText( i18n("Application Name"),
										  i18n("Insert the new application's name:") );
	QString command = KInputDialog::getText( i18n("Application Command"),
											 i18n("Insert the new application's command:") );
	QString comment = KInputDialog::getText( i18n("Application Comment"),
											 i18n("Insert a comment for the new application") );
	
	AutostartListViewItem *item = new AutostartListViewItem(appListView);
	item->setCommand(command);
	item->setComment(comment);
	item->setName(name);
	
	emit changed();
}

void AutostartWidget::load(QValueList<AppInfo>& list)
{
	appListView->clear();
	QValueListConstIterator<AppInfo> it = list.constBegin();
	QValueListConstIterator<AppInfo> end = list.constEnd();

	for( ; it!=end; ++it )
	{
		AutostartListViewItem *item = new AutostartListViewItem(appListView);
		item->setCommand((*it).command);
		item->setComment((*it).comment);
		item->setName((*it).name);
	}
}

QValueList<AppInfo> AutostartWidget::save() const
{
	AutostartListViewItem* item = dynamic_cast<AutostartListViewItem*>( appListView->firstChild() );
	QValueList<AppInfo> list;
	while( item != NULL ){
		AppInfo info;
		info.command = item->getCommand();
		info.comment = item->getComment();
		info.name = item->getName();
		list.append(info);
		
		item = dynamic_cast<AutostartListViewItem*>( item->nextSibling() );
	}
	return list;
}


#include "autostartwidget.moc"

