/***************************************************************************
 *   Copyright (C) 2005 by Felipe Sateler                                  *
 *   fsateler@gmail.com                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA 02110-1301, USA.           *
 ***************************************************************************/

#ifndef AUTOSTARTWIDGET_H
#define AUTOSTARTWIDGET_H

#include "autostartwidgetbase.h"

template <class T> class QValueList;

struct AppInfo
{
	QString name;
	QString comment;
	QString command;
};

class AutostartWidget : public AutostartWidgetBase
{
	Q_OBJECT

public:
	AutostartWidget(QWidget* parent = 0, const char* name = 0, WFlags fl = 0 );
	~AutostartWidget();
	/*$PUBLIC_FUNCTIONS$*/
	void load(QValueList<AppInfo>& info);
	QValueList<AppInfo> save() const;

public slots:
	/*$PUBLIC_SLOTS$*/
	virtual void          slotEdit();
	virtual void          slotRemove();
	virtual void          slotAdd();

signals:
	void changed();
protected:
	/*$PROTECTED_FUNCTIONS$*/

protected slots:
	/*$PROTECTED_SLOTS$*/

};

#endif

