/***************************************************************************
 *   Copyright (C) 2004, 2005 by Johnathan Burchill                              *
 *   jkerrb@users.sourceforge.net                                                        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifndef _ISOLATEARCHIVETHREAD_H_
#define _ISOLATEARCHIVETHREAD_H_

#include <kdarthread.h>

class kdar;

/**
 * This is the isolateArchiveThread class. It runs the
 * libdar:op_isolate isolation function, which extracts a catalog from the
 * archive.
 *
 * @short Archive isolation thread.
 * @author Johnathan K. Burchill, jkerrb@users.sourceforge.net
 * @version 1.3.0
 */
class isolateArchiveThread : public KDarThread {

public:
    /**
     * Constructor
     * @param aController the controller responsible for deleting the thread.
     * @param kdarconfig the configuration object (main, create or restore) for this
     * thread.
     */
    isolateArchiveThread( controller * aController, KDarConfig * kdarconfig );
    ~isolateArchiveThread();

    void run();

};

#endif // _ISOLATEARCHIVETHREAD_H_
