/***************************************************************************
 *   Copyright (C) 2004, 2005 by Johnathan Burchill                              *
 *   jkerrb@users.sourceforge.net                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "listArchiveThread.h"

#include "archiveHandle.h"
#include "controller.h"
#include "kdarConfig.h"
#include "KDarInteraction.h"
#include "kdarListViewItem.h"
#include "kdarArchiveBrowserUpdatesEvent.h"
#include "kdarPostListViewItemEvent.h"
#include "kdarSetCursorEvent.h"
#include "kdarStatusBarEvent.h"
#include "kdarWarningEvent.h"
#include "openArchiveThread.h"

#include <kcursor.h>
#include <kdebug.h>
#include <klistview.h>
#include <klocale.h>

#include <qapplication.h>
#include <qstring.h>

#include <dar/libdar.hpp>
#include <dar/tools.hpp>
#include <dar/erreurs.hpp>

#include <string>

extern bool libdarWorking;
extern kdarListViewItem *archiveItem;
extern kdarListViewItem *currentDirectory;

extern libdar::archive *theArchive;

listArchiveThread::listArchiveThread( controller * aController, KDarConfig * kdarconfig )
    : KDarThread( aController, kdarconfig )
{}

listArchiveThread::~listArchiveThread()
{
}

void listArchiveThread::run()
{
    //Every class that is derived from KDarThread must set this member variable:
    m_threadID = pthread_self();

    if ( libdarWorking )
    {
        return;
    }
    libdarWorking = true;
    setWaitCursor();
    enableCancelButton();
    //this is needed so that the archive gets opened
    //before we use it. Bad hack, as it makes UI thread
    //unresponsive
    m_controller->waitForThread( controller::OPEN_THREAD );
    //Safegaurd against missing archive pointer
    kdDebug() << "listArchiveThread::run() theArchive = " << theArchive << endl;
    if ( !theArchive )
    {
        disableCancelButton();
        setNormalCursor();
        libdarWorking = false;
        statusMessage( i18n( "Could not open archive." ) );
        deleteMe();
        return;
    }
    //call the libdar listing function
    libdar::et_mask selection;// = new et_mask();
    selection.add_mask(libdar::bool_mask(true));

    archiveHandle archiveHndl( m_kdc->archiveName() );

    kdarPostListViewItemEvent *postListViewEvent = new kdarPostListViewItemEvent( archiveHndl.getArchiveBasename(), true );
    QApplication::postEvent( m_controller, postListViewEvent );
    //Disable archive browser updates:
    disableBrowser();
    //Need some way to interact with user:
    KDarInteraction userInteractionDialog( m_controller );

    //Grab the top-level directory items
    try
    {
        currentDirectory = archiveItem;
        theArchive->get_children_of( userInteractionDialog, "");
    }
    catch( libdar::Euser_abort &e )
    {
        QString errorMessage = i18n( "Listing archive...cancelled by user." );
        statusMessage( errorMessage );
    }
    catch( libdar::Egeneric &e )
    {
        userInteractionDialog.warning( e.get_message() );
    }
    setNormalCursor();
    disableCancelButton();
    enableBrowser();
    libdarWorking = false;
    deleteMe();
}

