/***************************************************************************
 *   Copyright (C) 2004, 2005 by Johnathan Burchill                              *
 *   jkerrb@users.sourceforge.net                                                        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "testArchiveThread.h"

#include "kdarConfig.h"
#include "kdardeclarations.h"
#include "KDarInteraction.h"
#include "kdarSetCursorEvent.h"
#include "kdarstatistics.h"
#include "kdarStatusBarEvent.h"
#include "kdarWarningEvent.h"

#include <kapplication.h>
#include <kcursor.h>
#include <kdebug.h>
#include <klocale.h>

#include <qdatetime.h>
#include <qstring.h>

#include <dar/libdar.hpp>
#include <dar/tools.hpp>
#include <dar/erreurs.hpp>

#include <string>

extern bool libdarWorking;
extern libdar::archive *theArchive;

testArchiveThread::testArchiveThread( controller * aController, KDarConfig * kdarconfig, KListView * archiveFileView )
    : KDarThread( aController, kdarconfig, archiveFileView ){}

testArchiveThread::~testArchiveThread(){}

void testArchiveThread::run()
{
    //Every class that is derived from KDarThread must set this member variable:
    m_threadID = pthread_self();

    libdarWorking = true;
    //Start timing the operation:
    QDateTime startTime = QDateTime::currentDateTime();
    kdDebug() << "testArchiveThread::run(): logFile is " << m_kdc->logFile() << endl;
    openLogFile();
    kdDebug() << "testArchiveThread::run(): calling setWaitCursor()" << endl;
    setWaitCursor();
    kdDebug() << "testArchiveThread::run(): calling setCancelButton()" << endl;
    enableCancelButton();
    kdDebug() << "testArchiveThread::run(): calling logMessage()" << endl;
    logMessage( "\n" + i18n( "BEGIN TEST: " ) + QDateTime::currentDateTime().toString( "ddd dd MMM yyyy hh:mm:ss" ) + " " + m_kdc->archiveName() + "\n", true );
    logMessage( i18n( "command line: " ) + m_kdc->buildDarCommandLine( KDar::LIBDAR_TEST ) + "\n", true );
    statusMessage( i18n( "Testing archive...\n" ), FOREVER );

    //Need some way to interact with user:
    KDarInteraction userInteractionDialog( m_controller );

    //file masks
    libdar::et_mask selection;// = new et_mask();
    selection.add_mask(libdar::bool_mask(true));
    //Directories to include or exclude
    libdar::et_mask subtree;
//    libdar::et_mask subtree = m_kdc->libdarCreateDirectoryMask();
    //Also check for selected item in the archive file browser:
    libdar::ou_mask subIncludes = buildDirectoryMaskFromListView( "<ROOT>/" );
    if ( subIncludes.size() > 0 )
    {
        subtree.add_mask( subIncludes );
        kdDebug() << "testing got subIncludes." << endl;
    }
    else
    {
        subtree.add_mask( libdar::bool_mask( true ) );
    }

//    subtree.add_mask(libdar::bool_mask(true));
    try
    {
        KDarStatistics ks = theArchive->op_test( userInteractionDialog, selection, subtree, m_kdc->verbose() );
        logMessage( ks.testStatistics( (KDar::logLevel) m_kdc->logLevel() ) );
        statusMessage( i18n( "Testing archive...done.\n" ) );
        logMessage( timeDifference( startTime, QDateTime::currentDateTime() ) );
    }
    catch( libdar::Euser_abort &e )
    {
        QString errorMessage = i18n( "Testing archive...cancelled by user." );
        statusMessage( errorMessage );
        logMessage( errorMessage );
    }
    catch( libdar::Egeneric &e )
    {
        userInteractionDialog.warning( e.get_message() );
        QString errorMessage = i18n( "Testing archive...ERROR: could not test archive." );
        statusMessage( errorMessage );
        logMessage( e.get_message().c_str() );
        logMessage( errorMessage );
    }
    setNormalCursor();
    disableCancelButton();
    m_endMessage = i18n( "END TEST: " ) + QDateTime::currentDateTime().toString( "ddd dd MMM yyyy hh:mm:ss" ) + " " + m_kdc->archiveName() + "\n";
    libdarWorking = false;
    deleteMe();
}

