/***************************************************************************
 *                                                                         *
 *   copyright (C) 2004, 2005  by Michael Buesch                           *
 *   email: mbuesch@freenet.de                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation.                         *
 *                                                                         *
 ***************************************************************************/

#include "globalstuff.h"
#include "configuration.h"

#include <kmessagebox.h>
#include <klocale.h>

#include <sys/types.h>
#include <unistd.h>


QString PwMGlobal::humanReadableHex(const QByteArray &d)
{
	unsigned int i, size = d.size();
	QString ret("0x");
	char tmp[3], cur;

	for (i = 0; i < size; ++i) {
		cur = d[i];
		if (cur == 0)
			ret += "00";
		else {
			sprintf(tmp, "%X", cur & 0xFF);
			if (strlen(tmp) == 1)
				ret += '0';
			ret += tmp;
		}
	}
	return ret;
}

bool PwMGlobal::rootAlertMsgBox(QWidget *parent)
{
	if (geteuid() != 0)
		return false;
	if (conf()->confGlobCanExecAsRoot())
		return false;
	KMessageBox::error(parent,
			   i18n("Security Alert.\n"
				"This feature is not available, "
				"if you execute PwManager with \"root\" "
				"UID 0 privileges."),
			   i18n("Not Allowed as Root"));
	return true;
}
