/***************************************************************************
 *                                                                         *
 *   copyright (C) 2004 by Michael Buesch                                  *
 *   email: mbuesch@freenet.de                                             *
 *                                                                         *
 *   KWallet DCOP Interface is                                             *
 *    Copyright (c) 2002-2003 George Staikos <staikos@kde.org>             *
 *   KWallet is part of the KDE libraries                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation.                         *
 *                                                                         *
 ***************************************************************************/

#include "emutest.h"
#include "paramwnd.h"
#include "retwnd.h"

#include <kapplication.h>
#include <kmessagebox.h>

#include <qpushbutton.h>

#include <iostream>
using namespace std;

using namespace KWallet;


EmuTest::EmuTest(KApplication *_app)
{
	app = _app;
	wallet = 0;
}

EmuTest::~EmuTest()
{
	delete grid;
	if (wallet)
		delete wallet;
}

void EmuTest::init()
{
	grid = new GridView(2);
	connect(grid, SIGNAL(closed()),
		this, SLOT(gridClosed()));
	grid->setSpacing(3);
	initGridContent();
	grid->show();
}

void EmuTest::shutdown(int exitStatus)
{
	QApplication::exit(exitStatus);
}

void EmuTest::gridClosed()
{
	shutdown(0);
}

bool EmuTest::checkWallet()
{
	if (wallet)
		return true;
	KMessageBox::error(0, "invalid wallet pointer",
			   "invalid wallet pointer");
	return false;
}

void EmuTest::initGridContent()
{
	walletList_button = new QPushButton("static QStringList walletList()", grid);
	isEnabled_button = new QPushButton("static bool isEnabled()", grid);
	isOpen0_button = new QPushButton("static bool isOpen(QString)", grid);
	closeWallet_button = new QPushButton("static int closeWallet(QString, bool)", grid);
	deleteWallet_button = new QPushButton("static int deleteWallet(QString)", grid);
	disconnectApplication_button = new QPushButton("static bool disconnectApplication(QString, QCString)", grid);
	openWallet_button = new QPushButton("static Wallet* openWallet(QString, WId, OpenType)", grid);
	users_button = new QPushButton("static QStringList users(QString)", grid);
	LocalWallet_button = new QPushButton("static const QString LocalWallet()", grid);
	NetworkWallet_button = new QPushButton("static const QString NetworkWallet()", grid);
	PasswordFolder_button = new QPushButton("static const QString PasswordFolder()", grid);
	FormDataFolder_button = new QPushButton("static const QString FormDataFolder()", grid);
	changePassword_button = new QPushButton("static void changePassword(QString, WId)", grid);
	sync_button = new QPushButton("int sync()", grid);
	lockWallet_button = new QPushButton("int lockWallet()", grid);
	walletName_button = new QPushButton("QString walletName()", grid);
	isOpen1_button = new QPushButton("bool isOpen()", grid);
	requestChangePassword_button = new QPushButton("void requestChangePassword(WId)", grid);
	folderList_button = new QPushButton("QStringList folderList()", grid);
	hasFolder_button = new QPushButton("bool hasFolder(QString)", grid);
	setFolder_button = new QPushButton("bool setFolder(QString)", grid);
	removeFolder_button = new QPushButton("bool removeFolder(QString)", grid);
	createFolder_button = new QPushButton("bool createFolder(QString)", grid);
	currentFolder_button = new QPushButton("QString currentFolder()", grid);
	entryList_button = new QPushButton("QStringList entryList()", grid);
	renameEntry_button = new QPushButton("int renameEntry(QString, QString)", grid);
	readEntry_button = new QPushButton("int readEntry(QString, QByteArray&)", grid);
	readMap_button = new QPushButton("int readMap(QString, QMap<QString,QString>&)", grid);
	readPassword_button = new QPushButton("int readPassword(QString, QString&)", grid);
	writeEntry0_button = new QPushButton("int writeEntry(QString, QByteArray, EntryType)", grid);
	writeEntry1_button = new QPushButton("int writeEntry(QString, QByteArray)", grid);
	writeMap_button = new QPushButton("int writeMap(QString, QMap<QString,QString>)", grid);
	writePassword_button = new QPushButton("int writePassword(QString, QString)", grid);
	hasEntry_button = new QPushButton("bool hasEntry(QString)", grid);
	removeEntry_button = new QPushButton("int removeEntry(QString)", grid);
	entryType_button = new QPushButton("EntryType entryType(QString)", grid);
	folderDoesNotExist_button = new QPushButton("bool folderDoesNotExist(QString, QString)", grid);
	keyDoesNotExist_button = new QPushButton("bool keyDoesNotExist(QString, QString,  QString)", grid);
	delWallet_button = new QPushButton("delete the \"wallet\" object", grid);

	connect(walletList_button, SIGNAL(clicked()), this, SLOT(walletList_slot()));
	connect(isEnabled_button, SIGNAL(clicked()), this, SLOT(isEnabled_slot()));
	connect(isOpen0_button, SIGNAL(clicked()), this, SLOT(isOpen0_slot()));
	connect(closeWallet_button, SIGNAL(clicked()), this, SLOT(closeWallet_slot()));
	connect(deleteWallet_button, SIGNAL(clicked()), this, SLOT(deleteWallet_slot()));
	connect(disconnectApplication_button, SIGNAL(clicked()), this, SLOT(disconnectApplication_slot()));
	connect(openWallet_button, SIGNAL(clicked()), this, SLOT(openWallet_slot()));
	connect(users_button, SIGNAL(clicked()), this, SLOT(users_slot()));
	connect(LocalWallet_button, SIGNAL(clicked()), this, SLOT(LocalWallet_slot()));
	connect(NetworkWallet_button, SIGNAL(clicked()), this, SLOT(NetworkWallet_slot()));
	connect(PasswordFolder_button, SIGNAL(clicked()), this, SLOT(PasswordFolder_slot()));
	connect(FormDataFolder_button, SIGNAL(clicked()), this, SLOT(FormDataFolder_slot()));
	connect(changePassword_button, SIGNAL(clicked()), this, SLOT(changePassword_slot()));
	connect(sync_button, SIGNAL(clicked()), this, SLOT(sync_slot()));
	connect(lockWallet_button, SIGNAL(clicked()), this, SLOT(lockWallet_slot()));
	connect(walletName_button, SIGNAL(clicked()), this, SLOT(walletName_slot()));
	connect(isOpen1_button, SIGNAL(clicked()), this, SLOT(isOpen1_slot()));
	connect(requestChangePassword_button, SIGNAL(clicked()), this, SLOT(requestChangePassword_slot()));
	connect(folderList_button, SIGNAL(clicked()), this, SLOT(folderList_slot()));
	connect(hasFolder_button, SIGNAL(clicked()), this, SLOT(hasFolder_slot()));
	connect(setFolder_button, SIGNAL(clicked()), this, SLOT(setFolder_slot()));
	connect(removeFolder_button, SIGNAL(clicked()), this, SLOT(removeFolder_slot()));
	connect(createFolder_button, SIGNAL(clicked()), this, SLOT(createFolder_slot()));
	connect(currentFolder_button, SIGNAL(clicked()), this, SLOT(currentFolder_slot()));
	connect(entryList_button, SIGNAL(clicked()), this, SLOT(entryList_slot()));
	connect(renameEntry_button, SIGNAL(clicked()), this, SLOT(renameEntry_slot()));
	connect(readEntry_button, SIGNAL(clicked()), this, SLOT(readEntry_slot()));
	connect(readMap_button, SIGNAL(clicked()), this, SLOT(readMap_slot()));
	connect(readPassword_button, SIGNAL(clicked()), this, SLOT(readPassword_slot()));
	connect(writeEntry0_button, SIGNAL(clicked()), this, SLOT(writeEntry0_slot()));
	connect(writeEntry1_button, SIGNAL(clicked()), this, SLOT(writeEntry1_slot()));
	connect(writeMap_button, SIGNAL(clicked()), this, SLOT(writeMap_slot()));
	connect(writePassword_button, SIGNAL(clicked()), this, SLOT(writePassword_slot()));
	connect(hasEntry_button, SIGNAL(clicked()), this, SLOT(hasEntry_slot()));
	connect(removeEntry_button, SIGNAL(clicked()), this, SLOT(removeEntry_slot()));
	connect(entryType_button, SIGNAL(clicked()), this, SLOT(entryType_slot()));
	connect(folderDoesNotExist_button, SIGNAL(clicked()), this, SLOT(folderDoesNotExist_slot()));
	connect(keyDoesNotExist_button, SIGNAL(clicked()), this, SLOT(keyDoesNotExist_slot()));
	connect(delWallet_button, SIGNAL(clicked()), this, SLOT(delWallet_slot()));
}

void EmuTest::delWallet_slot()
{
	if (wallet) {
		delete wallet;
		wallet = 0;
	}
}

void EmuTest::walletList_slot()
{
	const char *funcId = "static QStringList walletList()";
	QStringList ret(KWallet::Wallet::walletList());
	RetWnd *rw = new RetWnd(funcId);
	rw->open_QStringList(ret);
}

void EmuTest::isEnabled_slot()
{
	const char *funcId = "static bool isEnabled()";
	bool ret = KWallet::Wallet::isEnabled();
	RetWnd *rw = new RetWnd(funcId);
	rw->open_bool(ret);
}

void EmuTest::isOpen0_slot()
{
	const char *funcId = "static bool isOpen(const QString& name)";
	ParamWnd *pw = new ParamWnd(funcId);
	QString arg0(pw->open_QString("const QString& name"));
	delete pw;
	bool ret = KWallet::Wallet::isOpen(arg0);
	RetWnd *rw = new RetWnd(funcId);
	rw->open_bool(ret);
}

void EmuTest::closeWallet_slot()
{
	const char *funcId = "static int closeWallet(const QString& name, bool force)";
	ParamWnd *pw = new ParamWnd(funcId);
	QString arg0(pw->open_QString("const QString& name"));
	delete pw;
	pw = new ParamWnd(funcId);
	bool arg1 = pw->open_bool("bool force");
	delete pw;
	int ret = KWallet::Wallet::closeWallet(arg0, arg1);
	RetWnd *rw = new RetWnd(funcId);
	rw->open_int(ret);
}

void EmuTest::deleteWallet_slot()
{
	const char *funcId = "static int deleteWallet(const QString& name)";
	ParamWnd *pw = new ParamWnd(funcId);
	QString arg0(pw->open_QString("const QString& name"));
	delete pw;
	int ret = KWallet::Wallet::deleteWallet(arg0);
	RetWnd *rw = new RetWnd(funcId);
	rw->open_int(ret);
}

void EmuTest::disconnectApplication_slot()
{
	const char *funcId = "static bool disconnectApplication(const QString& wallet, const QCString& app)";
	ParamWnd *pw = new ParamWnd(funcId);
	QString arg0(pw->open_QString("const QString& wallet"));
	delete pw;
	pw = new ParamWnd(funcId);
	QCString arg1(pw->open_QCString("const QCString& app"));
	delete pw;
	bool ret = KWallet::Wallet::disconnectApplication(arg0, arg1);
	RetWnd *rw = new RetWnd(funcId);
	rw->open_bool(ret);
}

void EmuTest::openWallet_slot()
{
	if (wallet) {
		KMessageBox::error(0, "already open", "already open");
		return;
	}
	const char *funcId = "static Wallet* openWallet(const QString& name, WId w = 0, OpenType ot = Synchronous)";
	ParamWnd *pw = new ParamWnd(funcId);
	QString arg0(pw->open_QString("const QString& name"));
	delete pw;
	pw = new ParamWnd(funcId);
	WId arg1 = pw->open_WId("WId w = 0");
	delete pw;
	pw = new ParamWnd(funcId);
	KWallet::Wallet::OpenType arg2 = pw->open_OpenType("OpenType ot = Synchronous");
	delete pw;
	wallet = KWallet::Wallet::openWallet(arg0, arg1, arg2);
	RetWnd *rw = new RetWnd(funcId);
	rw->open_pWallet(wallet);
}

void EmuTest::users_slot()
{
	const char *funcId = "static QStringList users(const QString& wallet)";
	ParamWnd *pw = new ParamWnd(funcId);
	QString arg0(pw->open_QString("const QString& wallet"));
	delete pw;
	QStringList ret(KWallet::Wallet::users(arg0));
	RetWnd *rw = new RetWnd(funcId);
	rw->open_QStringList(ret);
}

void EmuTest::LocalWallet_slot()
{
	const char *funcId = "static const QString LocalWallet()";
	QString ret(KWallet::Wallet::LocalWallet());
	RetWnd *rw = new RetWnd(funcId);
	rw->open_QString(ret);
}

void EmuTest::NetworkWallet_slot()
{
	const char *funcId = "static const QString NetworkWallet()";
	QString ret(KWallet::Wallet::NetworkWallet());
	RetWnd *rw = new RetWnd(funcId);
	rw->open_QString(ret);
}

void EmuTest::PasswordFolder_slot()
{
	const char *funcId = "static const QString PasswordFolder()";
	QString ret(KWallet::Wallet::PasswordFolder());
	RetWnd *rw = new RetWnd(funcId);
	rw->open_QString(ret);
}

void EmuTest::FormDataFolder_slot()
{
	const char *funcId = "static const QString FormDataFolder()";
	QString ret(KWallet::Wallet::FormDataFolder());
	RetWnd *rw = new RetWnd(funcId);
	rw->open_QString(ret);
}

void EmuTest::changePassword_slot()
{
	const char *funcId = "static void changePassword(const QString& name, WId w = 0)";
	ParamWnd *pw = new ParamWnd(funcId);
	QString arg0(pw->open_QString("const QString& name"));
	delete pw;
	pw = new ParamWnd(funcId);
	WId arg1 = pw->open_WId("WId w = 0");
	delete pw;
	KWallet::Wallet::changePassword(arg0, arg1);
}

void EmuTest::sync_slot()
{
	if (!checkWallet())
		return;
	const char *funcId = "int sync()";
	int ret = wallet->sync();
	RetWnd *rw = new RetWnd(funcId);
	rw->open_int(ret);
}

void EmuTest::lockWallet_slot()
{
	if (!checkWallet())
		return;
	const char *funcId = "int lockWallet()";
	int ret = wallet->lockWallet();
	RetWnd *rw = new RetWnd(funcId);
	rw->open_int(ret);
}

void EmuTest::walletName_slot()
{
	if (!checkWallet())
		return;
	const char *funcId = "const QString& walletName()";
	QString ret(wallet->walletName());
	RetWnd *rw = new RetWnd(funcId);
	rw->open_QString(ret);
}

void EmuTest::isOpen1_slot()
{
	if (!checkWallet())
		return;
	const char *funcId = "bool isOpen()";
	bool ret = wallet->isOpen();
	RetWnd *rw = new RetWnd(funcId);
	rw->open_bool(ret);
}

void EmuTest::requestChangePassword_slot()
{
	if (!checkWallet())
		return;
	const char *funcId = "void requestChangePassword(WId w = 0)";
	ParamWnd *pw = new ParamWnd(funcId);
	WId arg0 = pw->open_WId("WId w = 0");
	delete pw;
	wallet->requestChangePassword(arg0);
}

void EmuTest::folderList_slot()
{
	if (!checkWallet())
		return;
	const char *funcId = "QStringList folderList()";
	QStringList ret(wallet->folderList());
	RetWnd *rw = new RetWnd(funcId);
	rw->open_QStringList(ret);
}

void EmuTest::hasFolder_slot()
{
	if (!checkWallet())
		return;
	const char *funcId = "bool hasFolder(const QString& f)";
	ParamWnd *pw = new ParamWnd(funcId);
	QString arg0(pw->open_QString("const QString& f"));
	delete pw;
	bool ret = wallet->hasFolder(arg0);
	RetWnd *rw = new RetWnd(funcId);
	rw->open_bool(ret);
}

void EmuTest::setFolder_slot()
{
	if (!checkWallet())
		return;
	const char *funcId = "bool setFolder(const QString& f)";
	ParamWnd *pw = new ParamWnd(funcId);
	QString arg0(pw->open_QString("const QString& f"));
	delete pw;
	bool ret = wallet->setFolder(arg0);
	RetWnd *rw = new RetWnd(funcId);
	rw->open_bool(ret);
}

void EmuTest::removeFolder_slot()
{
	if (!checkWallet())
		return;
	const char *funcId = "bool removeFolder(const QString& f)";
	ParamWnd *pw = new ParamWnd(funcId);
	QString arg0(pw->open_QString("const QString& f"));
	delete pw;
	bool ret = wallet->removeFolder(arg0);
	RetWnd *rw = new RetWnd(funcId);
	rw->open_bool(ret);
}

void EmuTest::createFolder_slot()
{
	if (!checkWallet())
		return;
	const char *funcId = "bool createFolder(const QString& f)";
	ParamWnd *pw = new ParamWnd(funcId);
	QString arg0(pw->open_QString("const QString& f"));
	delete pw;
	bool ret = wallet->createFolder(arg0);
	RetWnd *rw = new RetWnd(funcId);
	rw->open_bool(ret);
}

void EmuTest::currentFolder_slot()
{
	if (!checkWallet())
		return;
	const char *funcId = "const QString& currentFolder()";
	QString ret(wallet->currentFolder());
	RetWnd *rw = new RetWnd(funcId);
	rw->open_QString(ret);
}

void EmuTest::entryList_slot()
{
	if (!checkWallet())
		return;
	const char *funcId = "QStringList entryList()";
	QStringList ret(wallet->entryList());
	RetWnd *rw = new RetWnd(funcId);
	rw->open_QStringList(ret);
}

void EmuTest::renameEntry_slot()
{
	if (!checkWallet())
		return;
	const char *funcId = "int renameEntry(const QString& oldName, const QString& newName)";
	ParamWnd *pw = new ParamWnd(funcId);
	QString arg0(pw->open_QString("const QString& oldName"));
	delete pw;
	pw = new ParamWnd(funcId);
	QString arg1(pw->open_QString("const QString& newName"));
	delete pw;
	int ret = wallet->renameEntry(arg0, arg1);
	RetWnd *rw = new RetWnd(funcId);
	rw->open_int(ret);
}

void EmuTest::readEntry_slot()
{
	if (!checkWallet())
		return;
	const char *funcId = "int readEntry(const QString& key, QByteArray& value)";
	ParamWnd *pw = new ParamWnd(funcId);
	QString arg0(pw->open_QString("const QString& key"));
	delete pw;
	QByteArray arg1;
	int ret = wallet->readEntry(arg0, arg1);
	RetWnd *rw = new RetWnd(funcId);
	rw->open_int(ret);
	rw = new RetWnd(funcId);
	rw->open_QByteArray(arg1);
}

void EmuTest::readMap_slot()
{
	if (!checkWallet())
		return;
	const char *funcId = "int readMap(const QString& key, QMap<QString,QString>& value)";
	ParamWnd *pw = new ParamWnd(funcId);
	QString arg0(pw->open_QString("const QString& key"));
	delete pw;
	QMap<QString,QString> arg1;
	int ret = wallet->readMap(arg0, arg1);
	RetWnd *rw = new RetWnd(funcId);
	rw->open_int(ret);
	rw = new RetWnd(funcId);
	rw->open_QMap_QString_QString(arg1);
}

void EmuTest::readPassword_slot()
{
	if (!checkWallet())
		return;
	const char *funcId = "int readPassword(const QString& key, QString& value)";
	ParamWnd *pw = new ParamWnd(funcId);
	QString arg0(pw->open_QString("const QString& key"));
	delete pw;
	QString arg1;
	int ret = wallet->readPassword(arg0, arg1);
	RetWnd *rw = new RetWnd(funcId);
	rw->open_int(ret);
	rw = new RetWnd(funcId);
	rw->open_QString(arg1);
}

void EmuTest::writeEntry0_slot()
{
	if (!checkWallet())
		return;
	const char *funcId = "int writeEntry(const QString& key, const QByteArray& value, EntryType entryType)";
	ParamWnd *pw = new ParamWnd(funcId);
	QString arg0(pw->open_QString("const QString& key"));
	delete pw;
	pw = new ParamWnd(funcId);
	QByteArray arg1(pw->open_QByteArray("const QByteArray& value"));
	delete pw;
	pw = new ParamWnd(funcId);
	KWallet::Wallet::EntryType arg2 = pw->open_EntryType("EntryType entryType");
	delete pw;
	int ret = wallet->writeEntry(arg0, arg1, arg2);
	RetWnd *rw = new RetWnd(funcId);
	rw->open_int(ret);
}

void EmuTest::writeEntry1_slot()
{
	if (!checkWallet())
		return;
	const char *funcId = "int writeEntry(const QString& key, const QByteArray& value)";
	ParamWnd *pw = new ParamWnd(funcId);
	QString arg0(pw->open_QString("const QString& key"));
	delete pw;
	pw = new ParamWnd(funcId);
	QByteArray arg1(pw->open_QByteArray("const QByteArray& value"));
	delete pw;
	int ret = wallet->writeEntry(arg0, arg1);
	RetWnd *rw = new RetWnd(funcId);
	rw->open_int(ret);
}

void EmuTest::writeMap_slot()
{
	if (!checkWallet())
		return;
	const char *funcId = "int writeMap(const QString& key, const QMap<QString,QString>& value)";
	ParamWnd *pw = new ParamWnd(funcId);
	QString arg0(pw->open_QString("const QString& key"));
	delete pw;
	pw = new ParamWnd(funcId);
	QMap<QString, QString> arg1(pw->open_QMap_QString_QString("const QMap<QString,QString>& value"));
	delete pw;
	int ret = wallet->writeMap(arg0, arg1);
	RetWnd *rw = new RetWnd(funcId);
	rw->open_int(ret);
}

void EmuTest::writePassword_slot()
{
	if (!checkWallet())
		return;
	const char *funcId = "int writePassword(const QString& key, const QString& value)";
	ParamWnd *pw = new ParamWnd(funcId);
	QString arg0(pw->open_QString("const QString& key"));
	delete pw;
	pw = new ParamWnd(funcId);
	QString arg1(pw->open_QString("const QString& value"));
	delete pw;
	int ret = wallet->writePassword(arg0, arg1);
	RetWnd *rw = new RetWnd(funcId);
	rw->open_int(ret);
}

void EmuTest::hasEntry_slot()
{
	if (!checkWallet())
		return;
	const char *funcId = "bool hasEntry(const QString& key)";
	ParamWnd *pw = new ParamWnd(funcId);
	QString arg0(pw->open_QString("const QString& key"));
	delete pw;
	bool ret = wallet->hasEntry(arg0);
	RetWnd *rw = new RetWnd(funcId);
	rw->open_bool(ret);
}

void EmuTest::removeEntry_slot()
{
	if (!checkWallet())
		return;
	const char *funcId = "int removeEntry(const QString& key)";
	ParamWnd *pw = new ParamWnd(funcId);
	QString arg0(pw->open_QString("const QString& key"));
	delete pw;
	int ret = wallet->removeEntry(arg0);
	RetWnd *rw = new RetWnd(funcId);
	rw->open_int(ret);
}

void EmuTest::entryType_slot()
{
	if (!checkWallet())
		return;
	const char *funcId = "EntryType entryType(const QString& key)";
	ParamWnd *pw = new ParamWnd(funcId);
	QString arg0(pw->open_QString("const QString& key"));
	delete pw;
	KWallet::Wallet::EntryType ret = wallet->entryType(arg0);
	RetWnd *rw = new RetWnd(funcId);
	rw->open_EntryType(ret);
}

void EmuTest::folderDoesNotExist_slot()
{
	const char *funcId = "static bool folderDoesNotExist(const QString& wallet, const QString& folder)";
	ParamWnd *pw = new ParamWnd(funcId);
	QString arg0(pw->open_QString("const QString& wallet"));
	delete pw;
	pw = new ParamWnd(funcId);
	QString arg1(pw->open_QString("const QString& folder"));
	delete pw;
	bool ret = KWallet::Wallet::folderDoesNotExist(arg0, arg1);
	RetWnd *rw = new RetWnd(funcId);
	rw->open_bool(ret);
}

void EmuTest::keyDoesNotExist_slot()
{
	const char *funcId = "static bool keyDoesNotExist(const QString& wallet, "
			     "const QString& folder, const QString& key)";
	ParamWnd *pw = new ParamWnd(funcId);
	QString arg0(pw->open_QString("const QString& wallet"));
	delete pw;
	pw = new ParamWnd(funcId);
	QString arg1(pw->open_QString("const QString& folder"));
	delete pw;
	pw = new ParamWnd(funcId);
	QString arg2(pw->open_QString("const QString& key"));
	delete pw;
	bool ret = KWallet::Wallet::keyDoesNotExist(arg0, arg1, arg2);
	RetWnd *rw = new RetWnd(funcId);
	rw->open_bool(ret);
}

#include "emutest.moc"
