/***************************************************************************
 *                                                                         *
 *   copyright (C) 2004 by Michael Buesch                                  *
 *   email: mbuesch@freenet.de                                             *
 *                                                                         *
 *   KWallet DCOP Interface is                                             *
 *    Copyright (c) 2002-2003 George Staikos <staikos@kde.org>             *
 *   KWallet is part of the KDE libraries                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation.                         *
 *                                                                         *
 ***************************************************************************/

#ifndef __EMUTEST_H
#define __EMUTEST_H

#include <qobject.h>
#include <qgrid.h>

#include <kwallet.h>

class KApplication;
class QPushButton;

class GridView : public QGrid
{
	Q_OBJECT
public:
	GridView(int n, QWidget *parent = 0,
		 const char *name = 0, WFlags f = 0)
	 : QGrid(n, parent, name, f)
		{ }

signals:
	void closed();

protected:
	void closeEvent(QCloseEvent *e)
		{
			emit closed();
			e->accept();
		}
};

class EmuTest : public QObject
{
	Q_OBJECT
public:
	EmuTest(KApplication *_app);
	~EmuTest();

	/** initialize the test */
	void init();
	/** shutdown the test */
	void shutdown(int exitStatus);

protected slots:
	/** grid closed */
	void gridClosed();

protected:
	/** initialize the grid contents */
	void initGridContent();
	/** check if "wallet" is valid */
	bool checkWallet();

protected:
	/** pointer to KApplication object */
	KApplication *app;
	/** Wallet object */
	KWallet::Wallet *wallet;
	/** Main grid view */
	GridView *grid;

protected:
	/* pointers to all buttons */
	QPushButton *walletList_button;
	QPushButton *isEnabled_button;
	QPushButton *isOpen0_button;
	QPushButton *closeWallet_button;
	QPushButton *deleteWallet_button;
	QPushButton *disconnectApplication_button;
	QPushButton *openWallet_button;
	QPushButton *users_button;
	QPushButton *LocalWallet_button;
	QPushButton *NetworkWallet_button;
	QPushButton *PasswordFolder_button;
	QPushButton *FormDataFolder_button;
	QPushButton *changePassword_button;
	QPushButton *sync_button;
	QPushButton *lockWallet_button;
	QPushButton *walletName_button;
	QPushButton *isOpen1_button;
	QPushButton *requestChangePassword_button;
	QPushButton *folderList_button;
	QPushButton *hasFolder_button;
	QPushButton *setFolder_button;
	QPushButton *removeFolder_button;
	QPushButton *createFolder_button;
	QPushButton *currentFolder_button;
	QPushButton *entryList_button;
	QPushButton *renameEntry_button;
	QPushButton *readEntry_button;
	QPushButton *readMap_button;
	QPushButton *readPassword_button;
	QPushButton *writeEntry0_button;
	QPushButton *writeEntry1_button;
	QPushButton *writeMap_button;
	QPushButton *writePassword_button;
	QPushButton *hasEntry_button;
	QPushButton *removeEntry_button;
	QPushButton *entryType_button;
	QPushButton *folderDoesNotExist_button;
	QPushButton *keyDoesNotExist_button;
	QPushButton *delWallet_button;

protected slots:
	/* button slots */
	void walletList_slot();
	void isEnabled_slot();
	void isOpen0_slot();
	void closeWallet_slot();
	void deleteWallet_slot();
	void disconnectApplication_slot();
	void openWallet_slot();
	void users_slot();
	void LocalWallet_slot();
	void NetworkWallet_slot();
	void PasswordFolder_slot();
	void FormDataFolder_slot();
	void changePassword_slot();
	void sync_slot();
	void lockWallet_slot();
	void walletName_slot();
	void isOpen1_slot();
	void requestChangePassword_slot();
	void folderList_slot();
	void hasFolder_slot();
	void setFolder_slot();
	void removeFolder_slot();
	void createFolder_slot();
	void currentFolder_slot();
	void entryList_slot();
	void renameEntry_slot();
	void readEntry_slot();
	void readMap_slot();
	void readPassword_slot();
	void writeEntry0_slot();
	void writeEntry1_slot();
	void writeMap_slot();
	void writePassword_slot();
	void hasEntry_slot();
	void removeEntry_slot();
	void entryType_slot();
	void folderDoesNotExist_slot();
	void keyDoesNotExist_slot();
	void delWallet_slot();
};

#endif // __EMUTEST_H
