/***************************************************************************
 *                                                                         *
 *   copyright (C) 2004, 2005  by Michael Buesch                           *
 *   email: mbuesch@freenet.de                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation.                         *
 *                                                                         *
 ***************************************************************************/

#include "masterkey/newmasterkeywndimpl.h"
#include "pwmexception.h"

#include <qtabwidget.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qlabel.h>

#include <klocale.h>
#include <kmessagebox.h>

#ifdef CONFIG_PWMANAGER_SMARTCARD
# include "masterkey/smartkey/smartkey.h"
#endif


/* XXX: If you change the mainTab in QT Designer, also change these defines! */
#define TAB_INDEX_PASSWORD	0
//#define TAB_INDEX_KEYFILE	1
#define TAB_INDEX_SMARTCARD	1


NewMasterKeyWndImpl::NewMasterKeyWndImpl(QWidget *_parent,
					 const char *name,
					 bool modal,
					 WFlags fl)
 : NewMasterKeyWnd(_parent, name, modal, fl)
 , parent (_parent)
 , lastType (MasterKey::type_none)
{
	checkForOkButton();
#ifndef CONFIG_PWMANAGER_SMARTCARD
	mainTab->removePage(mainTab->page(TAB_INDEX_SMARTCARD));
#endif
}

NewMasterKeyWndImpl::~NewMasterKeyWndImpl()
{
}

MasterKey::Type NewMasterKeyWndImpl::getLastKey(QByteArray *key)
{
	bool err;
	MasterKey::Type ret = MasterKey::type_none;

	if (lastType == ret || lastKey.isEmpty())
		goto out;
	key->duplicate(lastKey);
	err = lastKey.fill(0);
	PWM_ASSERT(err);
	ret = lastType;
	lastType = MasterKey::type_none;
out:
	return ret;
}

void NewMasterKeyWndImpl::setAllowedType(MasterKey::Type type)
{
	switch (type) {
	case MasterKey::type_password:
		mainTab->page(TAB_INDEX_PASSWORD)->setEnabled(true);
//		mainTab->page(TAB_INDEX_KEYFILE)->setEnabled(false);
#ifdef CONFIG_PWMANAGER_SMARTCARD
		mainTab->page(TAB_INDEX_SMARTCARD)->setEnabled(false);
#endif
		mainTab->setCurrentPage(TAB_INDEX_PASSWORD);
		break;
	case MasterKey::type_smartcard:
#ifdef CONFIG_PWMANAGER_SMARTCARD
		mainTab->page(TAB_INDEX_PASSWORD)->setEnabled(false);
//		mainTab->page(TAB_INDEX_KEYFILE)->setEnabled(false);
		mainTab->page(TAB_INDEX_SMARTCARD)->setEnabled(true);
		mainTab->setCurrentPage(TAB_INDEX_SMARTCARD);
#else
		PWM_ASSERT(false);
#endif
		break;
	case MasterKey::type_keyfile:
		mainTab->page(TAB_INDEX_PASSWORD)->setEnabled(false);
//		mainTab->page(TAB_INDEX_KEYFILE)->setEnabled(true);
#ifdef CONFIG_PWMANAGER_SMARTCARD
		mainTab->page(TAB_INDEX_SMARTCARD)->setEnabled(false);
#endif
//		mainTab->setCurrentPage(TAB_INDEX_KEYFILE);
		break;
	case MasterKey::type_none:
		PWM_ASSERT(false);
	case MasterKey::type_ok:
		PWM_ASSERT(false);
	case MasterKey::type_notimpl:
		PWM_ASSERT(false);
	}
}

void NewMasterKeyWndImpl::okButton_slot()
{
	switch (mainTab->currentPageIndex()) {
	case TAB_INDEX_PASSWORD: {
		// Be careful about character encoding here!
		if (pwLineEdit_0->text().local8Bit() != pwLineEdit_0->text().ascii()) {
			int res;
			res = KMessageBox::questionYesNo(this,
							 i18n("<QT>You are using special, non-ASCII characters, "
							      "in your password string. These depend on your "
							      "system LOCALE settings. The EURO sign is such "
							      "a character, for example. For more information "
							      "on ASCII characters, see<BR>"
							      "<A HREF=\"http://en.wikipedia.org/wiki/Ascii\">"
							      "http://en.wikipedia.org/wiki/Ascii</A><BR>"
							      "You may not be able to open this .pwm file "
							      "on another Computer with different LOCALE settings.<BR>"
							      "<BR>Do you really want to continue?</QT>"),
							 i18n("Locale Dependent Characters Detected"),
							 KStdGuiItem::yes(),
							 KStdGuiItem::no(),
							 "NewMasterKeyWnd_nonAsciiPw");
			if (res != KMessageBox::Yes)
				return;
		}
		lastType = MasterKey::type_password;
		lastKey = pwLineEdit_0->text().local8Bit();
		// make sure to strip the terminating NUL
		lastKey.truncate(lastKey.size() - 1);
		break;
	}
#if 0
	case TAB_INDEX_KEYFILE:
		lastType = MasterKey::type_keyfile;
		TODO();//TODO
		break;
#endif
	case TAB_INDEX_SMARTCARD: {
#ifdef CONFIG_PWMANAGER_SMARTCARD
		SmartKey sk(parent);
		if (!sk.requestKey(&lastKey))
			return;
		lastType = MasterKey::type_smartcard;
#else // CONFIG_PWMANAGER_SMARTCARD
		PWM_ASSERT(false);
#endif // CONFIG_PWMANAGER_SMARTCARD
		break;
	} default:
		PWM_ASSERT(false);
	}
	done(1);
}

void NewMasterKeyWndImpl::cancelButton_slot()
{
	done(0);
}

void NewMasterKeyWndImpl::pwChanged_slot()
{
	checkForOkButton();
}

void NewMasterKeyWndImpl::tabSwitched_slot()
{
	checkForOkButton();
}

void NewMasterKeyWndImpl::genSmartKeyButton_slot()
{
#ifdef CONFIG_PWMANAGER_SMARTCARD
	SmartKey sk(this);
	sk.genKey();
#endif // CONFIG_PWMANAGER_SMARTCARD
}

void NewMasterKeyWndImpl::checkForOkButton()
{
	bool enable = false;

	if (!mainTab->currentPage()->isEnabled())
		goto out;

	switch (mainTab->currentPageIndex()) {
	case TAB_INDEX_PASSWORD: {
		QString pw0(pwLineEdit_0->text());
		QString pw1(pwLineEdit_1->text());
		if (pw0.isEmpty() && pw1.isEmpty())
			pwInfoLabel->setText(i18n("Passwords are empty"));
		else if (pw0 != pw1)
			pwInfoLabel->setText(i18n("Passwords do not match"));
		else {
			enable = true;
			pwInfoLabel->setText(i18n("Passwords match"));
		}
		break;
	}
#if 0
	case TAB_INDEX_KEYFILE:
		//TODO
		TODO();
		break;
#endif
	case TAB_INDEX_SMARTCARD:
		// The OK button is always enabled in this tab.
		enable = true;
		break;
	default:
		PWM_ASSERT(false);
	}
out:
	okButton->setEnabled(enable);
}

#include "newmasterkeywndimpl.moc"
