/***************************************************************************
 *                                                                         *
 *   copyright (C) 2003, 2004 by Michael Buesch                            *
 *   email: mbuesch@freenet.de                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation.                         *
 *                                                                         *
 ***************************************************************************/

#ifndef PWMPRINT_H
#define PWMPRINT_H

#include <kconfig.h>

#include <qwidget.h>
#include <qstringlist.h>

class PwMDoc;

class PwMPrint
{
public:
	PwMPrint(PwMDoc *_doc, QWidget *_parent);
	~PwMPrint();

	/** start printing now */
	void printNow();
	/** set document */
	void setDoc(PwMDoc *_doc)
			{ doc = _doc; }

protected:
	/** generate a date-string */
	QString genDateString();
	/** request the user to select all categories to print */
	QStringList selCategories();

protected:
	/** document */
	PwMDoc *doc;
	/** parent widget */
	QWidget *parent;
};

#endif
