#ifndef GUI_H
#define GUI_H

#include <kmainwindow.h>
#include <k3listview.h>
#include <qsplitter.h>
#include <qdict.h>
#include <dcopobject.h>
#include <kurl.h>

class Renderer;

class Control : public KMainWindow
{
Q_OBJECT
	
public:
	Control();

	void addCreator(const QString &title);

public slots:
	void save(const KUrl &file);
	void save();
	void saveAs();
	
	void open();
	void open(const KUrl &file);
	
protected slots:
	void dropEvent(QDropEvent *e, QListViewItem *parent, QListViewItem *pafter);
	void currentChanged(QListViewItem *item);

private:
	QWidget *mRight;
	K3ListView *mTree, *mCreatorsList;
	QWidget *mConfigurator;
	
	KUrl mCurrentURL;
};

class RendererListView : public K3ListView
{
Q_OBJECT
public:
	RendererListView(QWidget *p);
	
protected:
	virtual bool acceptDrag(QDropEvent *event) const;
	virtual QDragObject *dragObject() const;
};


#endif
