// kclock - Clock screen saver for KDE
//
// Copyright (c) 2003, 2006, 2007 Melchior FRANZ <mfranz # kde : org>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

#ifndef __KCLOCK_H__
#define __KCLOCK_H__

#include <QTimer>
#include <QPainter>
#include <QWidget>

#include <KDialog>
#include <kscreensaver.h>

#include <iostream>		// TODO remove me
using namespace std;
class KClockSaver;

class KClockSetup : public KDialog
{
	Q_OBJECT
public:
	KClockSetup(QWidget *parent = 0);
	~KClockSetup();

protected:
	void readSettings();

private slots:
	void slotOk();
	void slotHelp();

	void slotBgndColor(const QColor &);
	void slotScaleColor(const QColor &);
	void slotHourColor(const QColor &);
	void slotMinColor(const QColor &);
	void slotSecColor(const QColor &);
	void slotSliderMoved(int);
	void slotKeepCenteredChanged(int);

private:
	KClockSaver *_saver;

	QColor _bgndColor;
	QColor _scaleColor;
	QColor _hourColor;
	QColor _minColor;
	QColor _secColor;

	int _size;
	bool _keepCentered;
};


class ClockPainter : public QPainter
{
public:
	ClockPainter(QWidget *parent = 0);
	virtual ~ClockPainter() {}
	void drawScale(QColor);
	void drawTick(double angle, double from, double to, double width, QColor, bool shadow = false);
	void drawDisc(double width, QColor, bool shadow = false);
	void drawHand(double angle, double length, double width, QColor, bool disc = true);
	void scale(qreal s) { s /= 2000.0; QPainter::scale(s, -s); }
};


class ClockWidget : public QWidget
{
	Q_OBJECT

public:
	ClockWidget(QWidget *parent = 0);
	~ClockWidget();
	inline void setScaleColor(const QColor& c) { _scaleColor = c; update(); }
	inline void setHourColor(const QColor& c) { _hourColor = c; update(); }
	inline void setMinColor(const QColor& c) { _minColor = c; update(); }
	inline void setSecColor(const QColor& c) { _secColor = c; update(); }

protected slots:
	void timerSlot();

protected:
	void paintEvent(QPaintEvent *event);

private:
	QTimer *_timer;
	int _hour;
	int _minute;
	int _second;
	bool _showSecond;

	QColor _scaleColor;
	QColor _hourColor;
	QColor _minColor;
	QColor _secColor;
};


class KClockSaver : public KScreenSaver
{
	Q_OBJECT

public:
	KClockSaver(WId id);
	virtual ~KClockSaver() {}
	inline void setBgndColor(const QColor &c) { _background->setPalette(QPalette(c)); }
	inline void setScaleColor(const QColor &c) { _clock_widget->setScaleColor(c); }
	inline void setHourColor(const QColor &c) { _clock_widget->setHourColor(c); }
	inline void setMinColor(const QColor &c) { _clock_widget->setMinColor(c); }
	inline void setSecColor(const QColor &c) { _clock_widget->setSecColor(c); }
	void setKeepCentered(bool b);
	void resizeClock(int size);

private:
	void readSettings();

protected slots:
	void slotTimeout();

protected:
	QWidget *_background;
	ClockWidget *_clock_widget;

	QTimer _timer;
	ClockPainter *_clock;

	int _x;
	int _y;
	int _xstep;
	int _ystep;
	int _diameter;
	int _size;
	bool _showSecond;
	bool _keepCentered;
};

#endif


