# - Try to find the kdegames library
# Once done this will define
#
#  KDEGAMES_FOUND - system has the kdegames library
#  KDEGAMES_INCLUDE_DIR - the kdegames include directory
#  KDEGAMES_LIBRARY - Link this to use the kdegames library
#
include(CheckLibraryExists)

if (KDEGAMES_INCLUDE_DIR AND KDEGAMES_LIBRARY)
    # in cache already
    SET(KDEGAMES_FOUND TRUE)

else (KDEGAMES_INCLUDE_DIR AND KDEGAMES_LIBRARY)

	# reset vars
	set(KDEGAMES_INCLUDE_DIR)
	set(KDEGAMES_LIBRARY)

	FIND_PATH(KDEGAMES_INCLUDE_DIR kstandardgameaction.h
  		${CMAKE_INSTALL_PREFIX}/include
  		/usr/local/include
  		/usr/include
  		${GNUWIN32_DIR}/include
	)

    set(CMAKE_LIBRARY_PATH ${LIB_INSTALL_DIR})
	find_library(KDEGAMES_LIBRARY NAMES kdegames
		PATHS
		${LIB_INSTALL_DIR}
  		/usr/lib
  		/usr/local/lib
  		${GNUWIN32_DIR}/lib
	)

	if(KDEGAMES_INCLUDE_DIR AND KDEGAMES_LIBRARY)
  		set(KDEGAMES_FOUND TRUE)
	endif(KDEGAMES_INCLUDE_DIR AND KDEGAMES_LIBRARY)

	if (KDEGAMES_FOUND)
	  if (NOT KDEGAMES_FIND_QUIETLY)
    	message(STATUS "Found KDEGames: ${KDEGAMES_LIBRARY}")
	  endif (NOT KDEGAMES_FIND_QUIETLY)
	else (KDEGAMES_FOUND)
	  if (KDEGAMES_FIND_REQUIRED)
	    message(FATAL_ERROR "Could NOT find KDEGames")
	  endif (KDEGAMES_FIND_REQUIRED)
	endif (KDEGAMES_FOUND)

	MARK_AS_ADVANCED(KDEGAMES_INCLUDE_DIR KDEGAMES_LIBRARY)
ENDIF(KDEGAMES_INCLUDE_DIR AND KDEGAMES_LIBRARY)

