/*
 * KAsteroids - Copyright Martin R. Jones 1997 <mjones@kde.org>
 *
 * Part of the KDE project
 */

#ifndef __AST_VIEW_H__
#define __AST_VIEW_H__

#include <QHash>
#include <QLinkedList>
#include <QWidget>
#include <krandomsequence.h>

#define MAX_POWER_LEVEL          1000

class QGraphicsScene;
class QGraphicsView;

class KRock;
class KMissile;
class KBit;
class KExhaust;
class KPowerup;
class KShield;
class KAstSprite;
class QGraphicsSimpleTextItem;

class KAsteroidsView : public QWidget
{
    Q_OBJECT
public:
    explicit KAsteroidsView( QWidget *parent = 0 );
    virtual ~KAsteroidsView();

    int refreshRate;

    void reset();
    void setRockSpeed( double rs ) { rockSpeed = rs; }
    void addRocks( int num );
    void newGame();
    void endGame();
    void newShip();

    void rotateLeft( bool r ) { rotateL = r; rotateSlow = 5; }
    void rotateRight( bool r ) { rotateR = r; rotateSlow = 5; }
    void thrust( bool t ) { thrustShip = t && shipPower > 0; }
    void shoot( bool s ) { shootShip = s; shootDelay = 0; }
    void setShield( bool s );
    void teleport( bool te) { teleportShip = te && mTeleportCount; }
    void brake( bool b );
    void pause( bool p);

    void showText( const QString &text, const QColor &color, bool scroll=true );
    void hideText();

    int shots() const { return shotsFired; }
    int hits() const { return shotsHit; }
    int power() const { return shipPower; }

    int teleportCount() const { return mTeleportCount; }
    int brakeCount() const { return mBrakeCount; }
    int shieldCount() const { return mShieldCount; }
    int shootCount() const { return mShootCount; }

signals:
    void shipKilled();
    void rockHit( int size );
    void rocksRemoved();
    void updateVitals();

private slots:
    void hideShield();

protected:
    void readSprites();
    void wrapSprite( KAstSprite * );
    void rockHit( KRock * );
    void reducePower( int val );
    void addExhaust( double x, double y, double dx, double dy, int count );
    void processMissiles();
    void processShip();
    void processPowerups();
    void processShield();

    virtual void resizeEvent( QResizeEvent *event );
    virtual void timerEvent( QTimerEvent * );

private:
    QGraphicsScene *field;
    QGraphicsView *view;
    QHash<int, QList<QPixmap>* > mAnimation;
    QLinkedList<KRock*> rocks;
    QLinkedList<KMissile*> missiles;
    QLinkedList<KBit*> bits;
    QLinkedList<KExhaust*> exhaust;
    QLinkedList<KPowerup*> powerups;
    KShield *shield;
    KAstSprite *ship;
    QGraphicsSimpleTextItem *textSprite;

    bool rotateL;
    bool rotateR;
    bool thrustShip;
    bool shootShip;
    bool teleportShip;
    bool brakeShip;
    bool pauseShip;
    bool shieldOn;

    bool vitalsChanged;

    int  shipAngle;
    int  rotateSlow;
    int  rotateRate;
    int  shipPower;

    int shotsFired;
    int shotsHit;
    int shootDelay;

    int mBrakeCount;
    int mShieldCount;
    int mTeleportCount;
    int mShootCount;

    double shipDx;
    double shipDy;

    int  textDy;
    int  mFrameNum;
    bool mPaused;
    int  mTimerId;

    double rockSpeed;
    double powerupSpeed;

    KRandomSequence krandom;
    QTimer *shieldTimer;
};

#endif
