#include "game_config.h"
#include "game_config.moc"

#include <QLabel>
#include <QCheckBox>

//Added by qt3to4:
#include <QVBoxLayout>

#include <klocale.h>
#include <knuminput.h>
#include <kdialog.h>
#include <kglobal.h>


//-----------------------------------------------------------------------------
AppearanceConfig::AppearanceConfig()
{
    int row = _grid->rowCount();
    int col = _grid->columnCount();

    QCheckBox *cb = new QCheckBox(i18n("Show piece's shadow"), _main);
    cb->setObjectName("kcfg_ShowPieceShadow");
    _grid->addWidget(cb, row, 0, 1, col);

    cb = new QCheckBox(i18n("Show next piece"), _main);
    cb->setObjectName("kcfg_ShowNextPiece");
    _grid->addWidget(cb, row+1, 0, 1, col);

    cb = new QCheckBox(i18n("Show detailed \"removed lines\" field"), _main);
    cb->setObjectName("kcfg_ShowDetailedRemoved");
    _grid->addWidget(cb, row+2, 0, 1, col);
}

//-----------------------------------------------------------------------------
GameConfig::GameConfig()
{
    setObjectName("game config");
    QVBoxLayout *top = new QVBoxLayout(this);
    top->setMargin(KDialog::marginHint());
    top->setSpacing(KDialog::spacingHint());

    _grid = new QGridLayout;
    top->addLayout(_grid);
    _grid->setColumnStretch(1, 1);

    QLabel *label = new QLabel(i18n("Initial level:"), this);
    _grid->addWidget(label, 0, 0);
    KIntNumInput *in = new KIntNumInput(this);
    in->setObjectName("kcfg_InitialGameLevel");	    
    in->setRange(1, 20, 1, true);
    _grid->addWidget(in, 0, 1);

    _grid->addItem( new QSpacerItem( 0, KDialog::spacingHint()), 1, 0 );

    QCheckBox *cb = new QCheckBox(i18n("Direct drop down"), this);
    cb->setObjectName("kcfg_DirectDropDownEnabled");
    cb->setWhatsThis( i18n("Drop down is not stopped when drop down key is released."));
    _grid->addWidget(cb, 2, 0, 1, 2);

    top->addStretch(1);
}

