#include "defines.h"

#include <klocale.h>

void errorBox(const QString &msg1, const QString &msg2, QWidget *parent)
{
    QString str;
    if ( msg2.isNull() ) str = msg1;
    else str = i18n("%1:\n%2", msg1, msg2);
    KMessageBox::error(parent, str);
}

bool checkSocket(bool res, const KNetwork::KSocketBase *socket,
                 const QString &msg, QWidget *parent)
{
    if ( res==true ) return false;
    errorBox(msg, socket->errorString(), parent);
    return true;
}
