#ifndef WIZARD_H
#define WIZARD_H

#include <QLabel>
#include <QLineEdit>
#include <kvbox.h>

#include <QPushButton>

#include <knuminput.h>
#include <kconfig.h>
#include <k3wizard.h>

#include "pline.h"
#include "mp_interface.h"

class ConnectionData;
class QGroupBox;

class MPWizard : public K3Wizard
{
 Q_OBJECT

 public:
	MPWizard(const MPGameInfo &gi, ConnectionData &cd,
			 QWidget *parent = 0, const char *name = 0);

	void showPage(QWidget *page);

 signals:
	void configureKeys(uint);

 protected slots:
	void accept();

 private slots:
	void typeChanged(int t);
	void lineTypeChanged(int);
	void configureKeysSlot();

 private:
	ConnectionData        &cd;
	enum Type { Local, Server, Client };
	Type                   type;
	KVBox                 *typePage, *localPage;
	WidgetList<PlayerLine> *wl;
	QLabel                 *lserver;
	QLineEdit              *eserver;
	KIntNumInput           *eport;
	QGroupBox *net;
//	QPushButton            *keys;

	void setupTypePage();
	void setupLocalPage(const MPGameInfo &gi);
	QString name(uint i) const;
};

#endif // WIZARD_H
