# Installation of GGZ game modules and GGZ library checks
# Josef Spillner <josef@ggzgamingzone.org> 2006, 2007
# see install_pam_service for some comments on DESTDIR etc.

###########################################################
# Documentation
# - call register_ggz_module(module.dsc) in your game's CMakeLists.txt
# - set -DGGZ_NOREGISTRY=/usr/share/ggz/modules/kdegames when building binary packages

###########################################################
# Check for existence of 'ggz-config' tool

FIND_PROGRAM(GGZCONFIG_EXECUTABLE NAMES ggz-config)

if(GGZCONFIG_EXECUTABLE)
    set(GGZCONFIG_FOUND 1)
    MESSAGE(STATUS "GGZ: Success: ggz-config was found.")
else(GGZCONFIG_EXECUTABLE)
    MESSAGE(STATUS "GGZ: Warning: ggz-config not found, game modules will not be registered!")
    MESSAGE(STATUS " Source package containing ggz-config: 'ggz-client-libs'")
    MESSAGE(STATUS " Binary package containing ggz-config: 'ggzcore-bin' (or similar)")
endif(GGZCONFIG_EXECUTABLE)

###########################################################
# Installation hook for module.dsc files

# FIXME: improve cmake to allow typed options
# option(GGZ_NOREGISTRY PATH "Directory where to install the module.dsc files to")

if(GGZCONFIG_FOUND)
    if(GGZ_NOREGISTRY)
        set(NOREG "--noregistry=${GGZ_NOREGISTRY}")
        MESSAGE(STATUS "GGZ: Installing game module information to ${GGZ_NOREGISTRY}.")
    else(GGZ_NOREGISTRY)
        EXECUTE_PROCESS(COMMAND ${GGZCONFIG_EXECUTABLE} -c OUTPUT_VARIABLE REG)
        STRING(REPLACE "\n" "" REG "${REG}")
        MESSAGE(STATUS "GGZ: Registering game module information into ${REG}.")
    endif(GGZ_NOREGISTRY)
    macro(register_ggz_module MODFILE)
        install(CODE "
            exec_program(${GGZCONFIG_EXECUTABLE} ARGS --install --force ${NOREG} --modfile=${CMAKE_CURRENT_SOURCE_DIR}/${MODFILE})
        ")
    endmacro(register_ggz_module)
else(GGZCONFIG_FOUND)
    macro(register_ggz_module MODFILE)
    endmacro(register_ggz_module)
endif(GGZCONFIG_FOUND)

###########################################################
# Check for the location of 'kggzmod' library

set(KGGZGAMES_INCLUDE_DIR ${CMAKE_SOURCE_DIR}/libkdegames)
set(KGGZGAMES_LIBS kggzgames kggzmod kggznet)
set(KGGZMOD_LIBS kggzmod kggznet)
set(KGGZNET_LIBS kggznet)
# FIXME: we don't really check yet and always use the internal copy

