/* This file is part of the KDE project
   Copyright (C) 2001 Carsten Pfeiffer <pfeiffer@kde.org>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation, version 2.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/

#ifndef MRML_H
#define MRML_H


#include <kio/tcpslavebase.h>
#include <kurl.h>

#include <kmrml_config.h>
#include "mrml_shared.h"

class Mrml : public KIO::TCPSlaveBase
{
public:
    Mrml( const QByteArray&, const QByteArray& );
    ~Mrml();

    virtual void get( const KUrl& url );

    virtual void mimetype( const KUrl& url );

private:
    QByteArray readAll();
    void emitData( const QByteArray& );

    bool startSession( const KUrl& url );

    // helpers
    inline QString sessionId() {
        return metaData( MrmlShared::sessionId() );
    }

    static QString mrmlString( const QString& sessionId,
                               const QString& transactionId = QString::null );

    static QByteArray loginString();
    static QByteArray getConfigurationString();
    static QByteArray getSessionsString( const QString& username,
                                       const QString& password );
    QString user( const KUrl& url ) {
        return url.hasUser() ?
            url.user() : m_config.defaultSettings().user;
    }
    QString pass( const KUrl& url ) {
        return url.hasPass() ?
            url.pass() : m_config.defaultSettings().pass;
    }

    bool checkLocalServer( const KUrl& url );

    static const int bufsize;
    QString defaultUser;
    QString defaultPass;

    KMrml::Config m_config;

};

#endif // MRML_H
