/***************************************************************************
 *  This file is part of the KDE libraries                                 *
 *  Copyright (c) 2005 Helge Deller <deller@kde.org>                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.          *
 ***************************************************************************/

#include <config.h>

#include <klocale.h>
#include <qcheckbox.h>
#include <qlayout.h>
#include <qwhatsthis.h>

#include "faxprintsettings.h"

FaxPrintSettings::FaxPrintSettings(QWidget *parent)
: KPrintDialogPage(parent)
{
  QString whatsThisScaleFullPage = i18n(
    "<qt>"
    "<p><strong>'Ignore Paper Margins'</strong></p>"
    "<p>"
    "If this checkbox is enabled, the paper margins will be ignored "
    "and the fax will be printed on the full paper size."
    "</p>"
    "<p>"
    "If this checkbox is disabled, Ligature will respect the standard paper "
    "margins and print the fax inside this printable area."
    "</p>"
    "</qt>"
  );

  QString whatsThisCenterHorz = i18n(
    "<qt>"
    "<p><strong>'Horizontally centered'</strong></p>"
    "<p>"
    "If this checkbox is enabled, the fax will be centered horizontally "
    "on the page."
    "</p>"
    "<p>"
    "If this checkbox is disabled, the fax will be printed at the left "
    "side of the page."
    "</p>"
    "</qt>"
  );

  QString whatsThisCenterVert = i18n(
    "<qt>"
    "<p><strong>'Vertically centered'</strong></p>"
    "<p>"
    "If this checkbox is enabled, the fax will be centered vertically "
    "on the page."
    "</p>"
    "<p>"
    "If this checkbox is disabled, the fax will be printed at the top "
    "of the page."
    "</p>"
    "</qt>"
  );

  setTitle(i18n("&Layout"));

  m_scaleFullPage = new QCheckBox(i18n("Ignore paper margins"), this);
  m_scaleFullPage->setWhatsThis(whatsThisScaleFullPage);
  m_center_horz = new QCheckBox(i18n("Horizontally centered"), this);
  m_center_horz->setWhatsThis(whatsThisCenterHorz);
  m_center_vert = new QCheckBox(i18n("Vertically centered"), this);
  m_center_vert->setWhatsThis(whatsThisCenterVert);

  QVBoxLayout* l0 = new QVBoxLayout(this);
  l0->setSpacing(10);
  l0->setMargin(0);
  l0->addWidget(m_scaleFullPage);
  l0->addWidget(m_center_horz);
  l0->addWidget(m_center_vert);
  l0->addStretch(1);
}

FaxPrintSettings::~FaxPrintSettings()
{
}

void FaxPrintSettings::getOptions(QMap<QString, QString>& opts, bool /*incldef*/)
{
  opts[FAX_SCALE_FULLPAGE] = (m_scaleFullPage->isChecked() ? "true" : "false");
  opts[FAX_CENTER_HORZ]    = (m_center_horz->isChecked() ? "true" : "false");
  opts[FAX_CENTER_VERT]    = (m_center_vert->isChecked() ? "true" : "false");
}

void FaxPrintSettings::setOptions(const QMap<QString, QString>& opts)
{
  m_scaleFullPage->setChecked(opts[FAX_SCALE_FULLPAGE] == "true");
  m_center_horz->setChecked(opts[FAX_CENTER_HORZ] != "false");
  m_center_vert->setChecked(opts[FAX_CENTER_VERT] == "true");
}

#include "faxprintsettings.moc"
