/***************************************************************************
 *   Copyright (C) 2003 by Stefan Kebekus                                  *
 *   kebekus@kde.org                                                       *
 *                                                                         *
 *   Copyright (C) 2005 by Wilfried Huss                                   *
 *   Wilfried.Huss@gmx.at                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.          *
 ***************************************************************************/

#include <kdebug.h>

#include <kapplication.h>
#include <kcombobox.h>
#include <klineedit.h>
#include <klocale.h>
#include <kurllabel.h>
#include <qcheckbox.h>
#include <qlabel.h>
#include <ktoolinvocation.h>

#include "optionDialogPdfWidget.h"
#include "prefs.h"


OptionDialogPdfWidget::OptionDialogPdfWidget(QWidget* parent)
    : OptionDialogPdfWidget_base(parent)
{
  // Set up the list of known and supported editors
  editorNameString        += i18n("User-Defined Editor");
  editorCommandString     += "";
  editorDescriptionString += i18n("Enter the command line below.");

  editorNameString        += "Emacs / emacsclient";
  editorCommandString     += "emacsclient --no-wait +%l %f || emacs +%l %f";
  editorDescriptionString += i18n("Click 'Help' to learn how to set up Emacs.");

  editorNameString        += "Kate";
  editorCommandString     += "kate --use --line %l %f";
  editorDescriptionString += i18n("Kate perfectly supports inverse search.");

  editorNameString        += "Kile";
  editorCommandString     += "kile %f --line %l";
  editorDescriptionString += i18n("Kile works very well");

  editorNameString        += "NEdit";
  editorCommandString     += "ncl -noask -line %l %f || nc -noask -line %l %f";
  editorDescriptionString += i18n("NEdit perfectly supports inverse search.");

  editorNameString        += "VIM - Vi IMproved / GUI";
  editorCommandString     += "gvim --servername KDVI --remote-silent +%l %f";
  editorDescriptionString += i18n("VIM version 6.0 or greater works just fine.");

  editorNameString        += "XEmacs / gnuclient";
  editorCommandString     += "gnuclient -q +%l %f || xemacs  +%l %f";
  editorDescriptionString += i18n("Click 'Help' to learn how to set up XEmacs.");

  for (int i=0; i<editorNameString.count(); i++)
    editorChoice->insertItem(i, editorNameString[i]);
  // Set the proper editor on the "Rendering-Page", try to recognize
  // the editor command from the config-file. If the editor command is
  // not recognized, switch to "User defined editor". That way, kdvi
  // stays compatible even if the EditorCommands[] change between
  // different versions of kdvi.
  QString currentEditorCommand = Prefs::editorCommand();
  int i;
  for (i = editorCommandString.count()-1; i>0; i--)
    if (editorCommandString[i] == currentEditorCommand)
      break;
  if (i == 0)
    usersEditorCommand = currentEditorCommand;
  slotComboBox(i);

  connect(urll, SIGNAL(leftClickedUrl(const QString&)), this, SLOT(slotExtraHelpButton(const QString&)));
  connect(editorChoice, SIGNAL(activated(int)), this, SLOT(slotComboBox(int)));

  // Editor description strings (and their translations) vary in
  // size. Find the longest description string available to make sure
  // that the page is always large enough.
  int maximumWidth = 0;
  for ( QStringList::Iterator it = editorDescriptionString.begin(); it != editorDescriptionString.end(); ++it ) {
    int width = editorDescription->fontMetrics().width(*it);
    if (width > maximumWidth)
      maximumWidth = width;
  }
  editorDescription->setMinimumWidth(maximumWidth+10);

  connect(kcfg_EditorCommand, SIGNAL(textChanged (const QString&)), this, SLOT(slotUserDefdEditorCommand(const QString &)));
}

OptionDialogPdfWidget::~OptionDialogPdfWidget()
{
}

void OptionDialogPdfWidget::slotUserDefdEditorCommand(const QString& text)
{
  if (isUserDefdEditor == true)
    EditorCommand = usersEditorCommand = text;
}


void OptionDialogPdfWidget::slotComboBox(int item)
{
  if (item != editorChoice->currentIndex())
    editorChoice->setCurrentIndex(item);

  editorDescription->setText(editorDescriptionString[item]);

  if (item != 0) {
    isUserDefdEditor = false;
    kcfg_EditorCommand->setText(editorCommandString[item]);
    kcfg_EditorCommand->setReadOnly(true);
    EditorCommand = editorCommandString[item];
  } else {
    kcfg_EditorCommand->setText(usersEditorCommand);
    kcfg_EditorCommand->setReadOnly(false);
    EditorCommand = usersEditorCommand;
    isUserDefdEditor = true;
  }
}

void OptionDialogPdfWidget::slotExtraHelpButton(const QString&)
{
  //KToolInvocation::invokeHelp("inv-search", "kdvi");
}

void OptionDialogPdfWidget::apply()
{
  Prefs::setEditorCommand(EditorCommand);
}


#include "optionDialogPdfWidget.moc"
