// -*- C++ -*-

/***************************************************************************
 *   Copyright (C) 2005 by Jeroen Wijnhout                                 *
 *   Jeroen.Wijnhout@kdemail.net                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.          *
 ***************************************************************************/


#ifndef _SOURCEFILESPLITTER_H
#define _SOURCEFILESPLITTER_H

#include <qfileinfo.h>

class QString;


class SourceFileSplitter
{
public:
  SourceFileSplitter(const QString& scrlink, const QString& dviFile);

  QString  fileName() { return m_fileInfo.fileName(); }
  QString  filePath() { return m_fileInfo.absoluteFilePath(); }
  bool     fileExists() { return m_fileInfo.exists(); }

  quint32 line()     { return m_line; }

private:
  QFileInfo m_fileInfo;
  quint32  m_line;
  bool      m_exists;
};

#endif
